/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\bJ\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R.\u00101\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u0001008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104\u00a8\u00065"}, d2={"Laccieo/cobbleworkers/jobs/Healer;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "Lnet/minecraft/world/entity/player/Player;", "findNearbyPlayers", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Ljava/util/List;", "handleHealing", "player", "doesPlayerHaveRegen", "(Lnet/minecraft/world/entity/player/Player;)Z", "isAllowedBySpecies", "isDesignatedHealer", "doesPokemonKnowHealingMove", "", "", "VALID_SPECIES", "Ljava/util/Set;", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HealingGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HealingGroup;", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "generalConfig", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "", "getSearchRadius", "()I", "searchRadius", "getSearchHeight", "searchHeight", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nHealer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Healer.kt\naccieo/cobbleworkers/jobs/Healer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n2423#2,14:131\n1761#2,3:145\n1761#2,3:148\n*S KotlinDebug\n*F\n+ 1 Healer.kt\naccieo/cobbleworkers/jobs/Healer\n*L\n71#1:131,14\n121#1:145,3\n128#1:148,3\n*E\n"})
public final class Healer
implements Worker {
    @NotNull
    public static final Healer INSTANCE = new Healer();
    @NotNull
    private static final Set<String> VALID_SPECIES;
    @NotNull
    private static final CobbleworkersConfig.HealingGroup config;
    @NotNull
    private static final CobbleworkersConfig.GeneralGroup generalConfig;
    @NotNull
    private static final JobType jobType;
    @Nullable
    private static final Function2<Level, BlockPos, Boolean> blockValidator;

    private Healer() {
    }

    private final int getSearchRadius() {
        return generalConfig.getSearchRadius();
    }

    private final int getSearchHeight() {
        return generalConfig.getSearchHeight();
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @Nullable
    public Function2<Level, BlockPos, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getHealersEnabled()) {
            return false;
        }
        return this.isDesignatedHealer(pokemonEntity) || this.isAllowedBySpecies(pokemonEntity) || this.doesPokemonKnowHealingMove(pokemonEntity);
    }

    @Override
    public void tick(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        this.handleHealing(world, origin, pokemonEntity);
    }

    private final List<Player> findNearbyPlayers(Level world, BlockPos origin) {
        AABB searchBox = new AABB(origin).inflate((double)this.getSearchRadius(), (double)this.getSearchHeight(), (double)this.getSearchRadius());
        List list = world.getEntitiesOfClass(Player.class, searchBox, arg_0 -> Healer.findNearbyPlayers$lambda$1(Healer::findNearbyPlayers$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesByClass(...)");
        return list;
    }

    private final void handleHealing(Level world, BlockPos origin, PokemonEntity pokemonEntity) {
        Object v0;
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<Player> nearbyPlayers = this.findNearbyPlayers(world, origin);
        if (nearbyPlayers.isEmpty()) {
            Intrinsics.checkNotNull((Object)pokemonId);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
            return;
        }
        Iterable $this$minByOrNull$iv = nearbyPlayers;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Player it = (Player)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distanceToSqr(pokemonEntity.position());
                do {
                    Object e$iv = iterator$iv.next();
                    Player it2 = (Player)e$iv;
                    $i$a$-minByOrNull-Healer$handleHealing$closestPlayer$1 = false;
                    double v$iv = it2.distanceToSqr(pokemonEntity.position());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Player player = v0;
        if (player == null) {
            return;
        }
        Player closestPlayer = player;
        if (this.doesPlayerHaveRegen(closestPlayer) || closestPlayer.getHealth() == closestPlayer.getMaxHealth()) {
            return;
        }
        Intrinsics.checkNotNull((Object)pokemonId);
        UUID currentTarget = CobbleworkersNavigationUtils.INSTANCE.getPlayerTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isPlayerTargeted(closestPlayer, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestPlayer, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestPlayer.getUUID())) {
            CobbleworkersNavigationUtils.navigateToPlayer$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestPlayer, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonNearPlayer$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestPlayer, 0.0, 4, null)) {
            if (!this.doesPlayerHaveRegen(closestPlayer)) {
                closestPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, config.getRegenDurationSeconds() * 20, config.getRegenAmplifier()));
            }
            CobbleworkersNavigationUtils.INSTANCE.releasePlayerTarget(pokemonId);
        }
    }

    private final boolean doesPlayerHaveRegen(Player player) {
        return player.hasEffect(MobEffects.REGENERATION);
    }

    private final boolean isAllowedBySpecies(PokemonEntity pokemonEntity) {
        if (!config.getChanseyLineHealsPlayers()) {
            return false;
        }
        String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String speciesName = string2;
        return VALID_SPECIES.contains(speciesName);
    }

    private final boolean isDesignatedHealer(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getHealers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean doesPokemonKnowHealingMove(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = pokemonEntity.getPokemon().getMoveSet().getMoves();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (!config.getHealingMoves().contains(it.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean findNearbyPlayers$lambda$0(Player it) {
        return true;
    }

    private static final boolean findNearbyPlayers$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"happiny", "chansey", "blissey"};
        VALID_SPECIES = SetsKt.setOf((Object[])objectArray);
        config = CobbleworkersConfigHolder.INSTANCE.getConfig().getHealing();
        generalConfig = CobbleworkersConfigHolder.INSTANCE.getConfig().getGeneral();
        jobType = JobType.Healer;
    }
}

