/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR&\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR&\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001f0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R.\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Laccieo/cobbleworkers/jobs/PickUpLooter;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleGeneration", "Laccieo/cobbleworkers/config/CobbleworkersConfig$PickUpGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$PickUpGroup;", "", "getCooldownTicks", "()J", "cooldownTicks", "", "Ljava/util/UUID;", "lastGenerationTime", "Ljava/util/Map;", "", "Lnet/minecraft/world/item/ItemStack;", "heldItemsByPokemon", "", "failedDepositLocations", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nPickUpLooter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PickUpLooter.kt\naccieo/cobbleworkers/jobs/PickUpLooter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1617#2,9:97\n1869#2:106\n1870#2:108\n1626#2:109\n1#3:107\n*S KotlinDebug\n*F\n+ 1 PickUpLooter.kt\naccieo/cobbleworkers/jobs/PickUpLooter\n*L\n81#1:97,9\n81#1:106\n81#1:108\n81#1:109\n81#1:107\n*E\n"})
public final class PickUpLooter
implements Worker {
    @NotNull
    public static final PickUpLooter INSTANCE = new PickUpLooter();
    @NotNull
    private static final CobbleworkersConfig.PickUpGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getPickup();
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, List<ItemStack>> heldItemsByPokemon = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Set<BlockPos>> failedDepositLocations = new LinkedHashMap();
    @NotNull
    private static final JobType jobType = JobType.PickUpLooter;
    @Nullable
    private static final Function2<Level, BlockPos, Boolean> blockValidator;

    private PickUpLooter() {
    }

    private final long getCooldownTicks() {
        return config.getPickUpLootingCooldownSeconds() * 20L;
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @Nullable
    public Function2<Level, BlockPos, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getPickUpLootersEnabled()) {
            return false;
        }
        return Intrinsics.areEqual((Object)pokemonEntity.getPokemon().getAbility().getName(), (Object)"pickup");
    }

    @Override
    public void tick(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<ItemStack> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            this.handleGeneration(world, origin, pokemonEntity);
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleGeneration(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        void $this$mapNotNullTo$iv$iv;
        long lastTime;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        long now = world.getGameTime();
        Long l = lastGenerationTime.get(pokemonId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getCooldownTicks()) {
            return;
        }
        LootParams lootParams = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.ORIGIN, (Object)origin.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)pokemonEntity).create(LootContextParamSets.CHEST);
        Iterable $this$mapNotNull$iv = config.getLootTables();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ResourceLocation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (ResourceLocation.tryParse((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List lootTables = (List)destination$iv$iv;
        if (lootTables.isEmpty()) {
            return;
        }
        ResourceLocation selectedId = (ResourceLocation)CollectionsKt.random((Collection)lootTables, (Random)((Random)Random.Default));
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)selectedId);
        LootTable lootTable = ((ServerLevel)world).getServer().reloadableRegistries().getLootTable(lootTableKey);
        ObjectArrayList drops = lootTable.getRandomItems(lootParams);
        Intrinsics.checkNotNull((Object)drops);
        if (!((Collection)drops).isEmpty()) {
            Long l3 = now;
            lastGenerationTime.put(pokemonId, l3);
            heldItemsByPokemon.put(pokemonId, (List<ItemStack>)drops);
        }
    }
}

