/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.integration.FarmersDelightBlocks;
import accieo.cobbleworkers.jobs.CropHarvester;
import accieo.cobbleworkers.jobs.CropIrrigator;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.block.MedicinalLeekBlock;
import com.cobblemon.mod.common.block.RevivalHerbBlock;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u000fJG\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00142\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersCropUtils;", "", "<init>", "()V", "", "Lnet/minecraft/world/level/block/Block;", "externalBlocks", "", "addCompatibility", "(Ljava/util/Set;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "findClosestFarmland", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "findClosestCrop", "blockPos", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "Ljava/util/UUID;", "", "Lnet/minecraft/world/item/ItemStack;", "pokemonHeldItems", "Laccieo/cobbleworkers/config/CobbleworkersConfig$CropHarvestGroup;", "config", "harvestCrop", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Ljava/util/Map;Laccieo/cobbleworkers/config/CobbleworkersConfig$CropHarvestGroup;)V", "pos", "", "isMatureCrop", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "", "validCropBlocks", "Ljava/util/Set;", "getValidCropBlocks", "()Ljava/util/Set;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nCobbleworkersCropUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleworkersCropUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersCropUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n774#2:170\n865#2,2:171\n2423#2,14:173\n774#2:187\n865#2,2:188\n2423#2,14:190\n*S KotlinDebug\n*F\n+ 1 CobbleworkersCropUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersCropUtils\n*L\n73#1:170\n73#1:171,2\n77#1:173,14\n88#1:187\n88#1:188,2\n91#1:190,14\n*E\n"})
public final class CobbleworkersCropUtils {
    @NotNull
    public static final CobbleworkersCropUtils INSTANCE = new CobbleworkersCropUtils();
    @NotNull
    private static final Set<Block> validCropBlocks;

    private CobbleworkersCropUtils() {
    }

    @NotNull
    public final Set<Block> getValidCropBlocks() {
        return validCropBlocks;
    }

    public final void addCompatibility(@NotNull Set<? extends Block> externalBlocks) {
        Intrinsics.checkNotNullParameter(externalBlocks, (String)"externalBlocks");
        validCropBlocks.addAll((Collection<Block>)externalBlocks);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockPos findClosestFarmland(@NotNull Level world, @NotNull BlockPos origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, JobType.CropIrrigator);
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            BlockState state = world.getBlockState(pos);
            if (!((Boolean)CropIrrigator.INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && ((Number)((Object)state.getValue((Property)FarmBlock.MOISTURE))).intValue() <= 2 && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-CobbleworkersCropUtils$findClosestFarmland$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockPos findClosestCrop(@NotNull Level world, @NotNull BlockPos origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, JobType.CropHarvester);
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)CropHarvester.INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && INSTANCE.isMatureCrop(world, pos) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-CobbleworkersCropUtils$findClosestCrop$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void harvestCrop(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull PokemonEntity pokemonEntity, @NotNull Map<UUID, List<ItemStack>> pokemonHeldItems, @NotNull CobbleworkersConfig.CropHarvestGroup config) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter(pokemonHeldItems, (String)"pokemonHeldItems");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        BlockState blockState2 = world.getBlockState(blockPos);
        if (!validCropBlocks.contains(blockState2.getBlock())) {
            return;
        }
        LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.ORIGIN, (Object)blockPos.getCenter()).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState2).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)pokemonEntity);
        List drops = blockState2.getDrops(lootParams);
        Intrinsics.checkNotNull((Object)drops);
        if (!((Collection)drops).isEmpty()) {
            pokemonHeldItems.put(pokemonEntity.getPokemon().getUuid(), drops);
        }
        Block block = blockState2.getBlock();
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        boolean isFarmersDelightCrop = FarmersDelightBlocks.INSTANCE.getALL().contains(blockId);
        boolean isTomato = Intrinsics.areEqual((Object)blockId, (Object)"tomatoes");
        boolean isRice = Intrinsics.areEqual((Object)blockId, (Object)"rice_panicles");
        boolean isMushroomColony = FarmersDelightBlocks.INSTANCE.getMUSHROOMS().contains(blockId);
        if (config.getShouldReplantCrops()) {
            if (isRice && blockState2.hasProperty((Property)BlockStateProperties.AGE_3)) {
                blockState = Blocks.AIR.defaultBlockState();
            } else if (isTomato && blockState2.hasProperty((Property)BlockStateProperties.AGE_3)) {
                blockState = (BlockState)blockState2.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0));
            } else if (isMushroomColony && blockState2.hasProperty((Property)BlockStateProperties.AGE_3)) {
                blockState = (BlockState)blockState2.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0));
            } else if (isFarmersDelightCrop && blockState2.hasProperty((Property)CropBlock.AGE)) {
                blockState = (BlockState)blockState2.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.POTATOES)) {
                blockState = (BlockState)blockState2.setValue((Property)PotatoBlock.AGE, (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.BEETROOTS)) {
                blockState = (BlockState)blockState2.setValue((Property)BeetrootBlock.AGE, (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.CARROTS)) {
                blockState = (BlockState)blockState2.setValue((Property)CarrotBlock.AGE, (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.WHEAT)) {
                blockState = (BlockState)blockState2.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.SWEET_BERRY_BUSH)) {
                blockState = (BlockState)blockState2.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.CAVE_VINES)) {
                blockState = (BlockState)blockState2.setValue((Property)CaveVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(false));
            } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.CAVE_VINES_PLANT)) {
                blockState = (BlockState)blockState2.setValue((Property)CaveVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(false));
            } else if (Intrinsics.areEqual((Object)block, (Object)CobblemonBlocks.REVIVAL_HERB)) {
                blockState = (BlockState)blockState2.setValue((Property)RevivalHerbBlock.Companion.getAGE(), (Comparable)Integer.valueOf(0));
            } else if (Intrinsics.areEqual((Object)block, (Object)CobblemonBlocks.MEDICINAL_LEEK)) {
                blockState = (BlockState)blockState2.setValue((Property)MedicinalLeekBlock.Companion.getAGE(), (Comparable)Integer.valueOf(0));
            } else {
                if (!Intrinsics.areEqual((Object)block, (Object)CobblemonBlocks.VIVICHOKE_SEEDS)) return;
                blockState = Blocks.AIR.defaultBlockState();
            }
        } else {
            blockState = Intrinsics.areEqual((Object)block, (Object)Blocks.SWEET_BERRY_BUSH) ? (BlockState)blockState2.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)) : (Intrinsics.areEqual((Object)block, (Object)Blocks.CAVE_VINES) ? (BlockState)blockState2.setValue((Property)CaveVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(false)) : (Intrinsics.areEqual((Object)block, (Object)Blocks.CAVE_VINES_PLANT) ? (BlockState)blockState2.setValue((Property)CaveVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(false)) : Blocks.AIR.defaultBlockState()));
        }
        BlockState newState = blockState;
        world.setBlockAndUpdate(blockPos, newState);
    }

    private final boolean isMatureCrop(Level world, BlockPos pos) {
        boolean bl;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        if (block instanceof CropBlock) {
            bl = ((CropBlock)block).getAge(state) == ((CropBlock)block).getMaxAge();
        } else if (block instanceof CaveVines) {
            Comparable comparable = state.getValue((Property)CaveVinesPlantBlock.BERRIES);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"get(...)");
            bl = (Boolean)comparable;
        } else if (block instanceof SweetBerryBushBlock) {
            Integer n = (Integer)state.getValue((Property)SweetBerryBushBlock.AGE);
            int n2 = 3;
            bl = n != null && n == n2;
        } else if (FarmersDelightBlocks.INSTANCE.getMUSHROOMS().contains(blockId) && state.hasProperty((Property)BlockStateProperties.AGE_3)) {
            Integer n = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
            int n3 = 3;
            bl = n != null && n == n3;
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        Object[] objectArray = new Block[]{Blocks.POTATOES, Blocks.BEETROOTS, Blocks.CARROTS, Blocks.WHEAT, Blocks.SWEET_BERRY_BUSH, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, CobblemonBlocks.REVIVAL_HERB, CobblemonBlocks.MEDICINAL_LEEK, CobblemonBlocks.VIVICHOKE_SEEDS};
        validCropBlocks = SetsKt.mutableSetOf((Object[])objectArray);
    }
}

