/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bR\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR&\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001fR&\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0#0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001fR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020)8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R,\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Laccieo/cobbleworkers/jobs/Archeologist;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "origin", "", "tick", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleHarvesting", "findClosestArcheologySpot", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "handleGeneration", "isDesignatedHarvester", "Laccieo/cobbleworkers/config/CobbleworkersConfig$ArcheologyGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$ArcheologyGroup;", "", "getCooldownTicks", "()J", "cooldownTicks", "", "Ljava/util/UUID;", "lastGenerationTime", "Ljava/util/Map;", "", "Lnet/minecraft/class_1799;", "heldItemsByPokemon", "", "failedDepositLocations", "", "Lnet/minecraft/class_2248;", "validBlocks", "Ljava/util/Set;", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nArcheologist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Archeologist.kt\naccieo/cobbleworkers/jobs/Archeologist\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n774#2:168\n865#2,2:169\n2423#2,14:171\n1617#2,9:185\n1869#2:194\n1870#2:196\n1626#2:197\n1761#2,3:198\n1#3:195\n*S KotlinDebug\n*F\n+ 1 Archeologist.kt\naccieo/cobbleworkers/jobs/Archeologist\n*L\n120#1:168\n120#1:169,2\n123#1:171,14\n143#1:185,9\n143#1:194\n143#1:196\n143#1:197\n165#1:198,3\n143#1:195\n*E\n"})
public final class Archeologist
implements Worker {
    @NotNull
    public static final Archeologist INSTANCE = new Archeologist();
    @NotNull
    private static final CobbleworkersConfig.ArcheologyGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getArcheology();
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, List<class_1799>> heldItemsByPokemon = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Set<class_2338>> failedDepositLocations = new LinkedHashMap();
    @NotNull
    private static final Set<class_2248> validBlocks;
    @NotNull
    private static final JobType jobType;
    @NotNull
    private static final Function2<class_1937, class_2338, Boolean> blockValidator;

    private Archeologist() {
    }

    private final long getCooldownTicks() {
        return config.getArcheologyLootingCooldownSeconds() * 20L;
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<class_1937, class_2338, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getArcheologistsEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeDoesArcheology(), pokemonEntity) || this.isDesignatedHarvester(pokemonEntity);
    }

    @Override
    public void tick(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<class_1799> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            this.handleHarvesting(world, origin, pokemonEntity);
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    private final void handleHarvesting(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        class_2338 class_23382 = this.findClosestArcheologySpot(world, origin);
        if (class_23382 == null) {
            return;
        }
        class_2338 closestBlock = class_23382;
        Intrinsics.checkNotNull((Object)pokemonId);
        class_2338 currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestBlock, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestBlock, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestBlock, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestBlock)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestBlock, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            this.handleGeneration(world, closestBlock, pokemonEntity);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final class_2338 findClosestArcheologySpot(class_1937 world, class_2338 origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<class_2338> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 pos = (class_2338)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_2338 it = (class_2338)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_10262((class_2382)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    class_2338 it2 = (class_2338)e$iv;
                    $i$a$-minByOrNull-Archeologist$findClosestArcheologySpot$2 = false;
                    double v$iv = it2.method_10262((class_2382)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final void handleGeneration(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        void $this$mapNotNullTo$iv$iv;
        long lastTime;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        long now = world.method_8510();
        Long l = lastGenerationTime.get(pokemonId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getCooldownTicks()) {
            return;
        }
        class_8567 lootParams = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)origin.method_46558()).method_51874(class_181.field_1226, (Object)pokemonEntity).method_51875(class_173.field_1179);
        Iterable $this$mapNotNull$iv = config.getLootTables();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_2960 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (class_2960.method_12829((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List lootTables = (List)destination$iv$iv;
        if (lootTables.isEmpty()) {
            return;
        }
        class_2960 selectedId = (class_2960)CollectionsKt.random((Collection)lootTables, (Random)((Random)Random.Default));
        class_5321 lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)selectedId);
        class_52 lootTable = ((class_3218)world).method_8503().method_58576().method_58295(lootTableKey);
        ObjectArrayList drops = lootTable.method_51878(lootParams);
        Intrinsics.checkNotNull((Object)drops);
        if (!((Collection)drops).isEmpty()) {
            Long l3 = now;
            lastGenerationTime.put(pokemonId, l3);
            heldItemsByPokemon.put(pokemonId, (List<class_1799>)drops);
        }
    }

    private final boolean isDesignatedHarvester(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getArcheologists();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean blockValidator$lambda$0(class_1937 world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_2680 state = world.method_8320(pos);
        class_2680 aboveState = world.method_8320(pos.method_10084());
        return validBlocks.contains(state.method_26204()) && aboveState.method_26215();
    }

    static {
        Object[] objectArray = new class_2248[]{class_2246.field_10566, class_2246.field_10255, class_2246.field_37576, class_2246.field_10253, class_2246.field_28685};
        validBlocks = SetsKt.setOf((Object[])objectArray);
        jobType = JobType.Archeologist;
        blockValidator = Archeologist::blockValidator$lambda$0;
    }
}

