/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR,\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Laccieo/cobbleworkers/jobs/FireExtinguisher;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "origin", "", "tick", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleFireExtinguishing", "findClosestFire", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "isDesignatedExtinguisher", "Laccieo/cobbleworkers/config/CobbleworkersConfig$ExtinguisherGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$ExtinguisherGroup;", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nFireExtinguisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FireExtinguisher.kt\naccieo/cobbleworkers/jobs/FireExtinguisher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n2423#2,14:101\n1761#2,3:115\n*S KotlinDebug\n*F\n+ 1 FireExtinguisher.kt\naccieo/cobbleworkers/jobs/FireExtinguisher\n*L\n83#1:98\n83#1:99,2\n86#1:101,14\n95#1:115,3\n*E\n"})
public final class FireExtinguisher
implements Worker {
    @NotNull
    public static final FireExtinguisher INSTANCE = new FireExtinguisher();
    @NotNull
    private static final CobbleworkersConfig.ExtinguisherGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getExtinguisher();
    @NotNull
    private static final JobType jobType = JobType.FireExtinguisher;
    @NotNull
    private static final Function2<class_1937, class_2338, Boolean> blockValidator = FireExtinguisher::blockValidator$lambda$0;

    private FireExtinguisher() {
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<class_1937, class_2338, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getExtinguishersEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeExtinguishesFire(), pokemonEntity) || this.isDesignatedExtinguisher(pokemonEntity);
    }

    @Override
    public void tick(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        this.handleFireExtinguishing(world, origin, pokemonEntity);
    }

    private final void handleFireExtinguishing(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        class_2338 class_23382 = this.findClosestFire(world, origin);
        if (class_23382 == null) {
            return;
        }
        class_2338 closestFire = class_23382;
        Intrinsics.checkNotNull((Object)pokemonId);
        class_2338 currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestFire, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestFire, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestFire, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestFire)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestFire, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            world.method_8501(closestFire, class_2246.field_10124.method_9564());
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final class_2338 findClosestFire(class_1937 world, class_2338 origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<class_2338> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 pos = (class_2338)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_2338 it = (class_2338)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_10262((class_2382)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    class_2338 it2 = (class_2338)e$iv;
                    $i$a$-minByOrNull-FireExtinguisher$findClosestFire$2 = false;
                    double v$iv = it2.method_10262((class_2382)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final boolean isDesignatedExtinguisher(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getExtinguishers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean blockValidator$lambda$0(class_1937 world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_2680 state = world.method_8320(pos);
        return Intrinsics.areEqual((Object)state.method_26204(), (Object)class_2246.field_10036);
    }
}

