/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ-\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\bR&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR&\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001c0\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u001a\u0010+\u001a\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R.\u00100\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010/8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Laccieo/cobbleworkers/jobs/GroundItemGatherer;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "origin", "", "tick", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleGathering", "Lkotlin/Pair;", "Lnet/minecraft/class_1542;", "findClosestItem", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Lkotlin/Pair;", "isDesignatedGatherer", "", "Ljava/util/UUID;", "", "Lnet/minecraft/class_1799;", "heldItemsByPokemon", "Ljava/util/Map;", "", "failedDepositLocations", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GroundItemGathererGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GroundItemGathererGroup;", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "generalConfig", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "", "getSearchRadius", "()I", "searchRadius", "getSearchHeight", "searchHeight", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nGroundItemGatherer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroundItemGatherer.kt\naccieo/cobbleworkers/jobs/GroundItemGatherer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1761#3,3:110\n*S KotlinDebug\n*F\n+ 1 GroundItemGatherer.kt\naccieo/cobbleworkers/jobs/GroundItemGatherer\n*L\n106#1:110,3\n*E\n"})
public final class GroundItemGatherer
implements Worker {
    @NotNull
    public static final GroundItemGatherer INSTANCE = new GroundItemGatherer();
    @NotNull
    private static final Map<UUID, List<class_1799>> heldItemsByPokemon = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Set<class_2338>> failedDepositLocations = new LinkedHashMap();
    @NotNull
    private static final CobbleworkersConfig.GroundItemGathererGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getGroundItemGathering();
    @NotNull
    private static final CobbleworkersConfig.GeneralGroup generalConfig = CobbleworkersConfigHolder.INSTANCE.getConfig().getGeneral();
    @NotNull
    private static final JobType jobType = JobType.GroundItemGatherer;
    @Nullable
    private static final Function2<class_1937, class_2338, Boolean> blockValidator;

    private GroundItemGatherer() {
    }

    private final int getSearchRadius() {
        return generalConfig.getSearchRadius();
    }

    private final int getSearchHeight() {
        return generalConfig.getSearchHeight();
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @Nullable
    public Function2<class_1937, class_2338, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getGroundItemGatheringEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeGathersGroundItems(), pokemonEntity) || this.isDesignatedGatherer(pokemonEntity);
    }

    @Override
    public void tick(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<class_1799> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            this.handleGathering(world, origin, pokemonEntity);
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    private final void handleGathering(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        Pair<class_2338, class_1542> pair = this.findClosestItem(world, origin);
        if (pair == null) {
            return;
        }
        Pair<class_2338, class_1542> pair2 = pair;
        class_2338 closestItemPos = (class_2338)pair2.component1();
        class_1542 closestItem = (class_1542)pair2.component2();
        Intrinsics.checkNotNull((Object)pokemonId);
        class_2338 currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestItemPos, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestItemPos, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestItemPos, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestItemPos)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestItemPos, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            class_1799 stack = closestItem.method_6983().method_7972();
            closestItem.method_31472();
            heldItemsByPokemon.put(pokemonId, CollectionsKt.listOf((Object)stack));
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    private final Pair<class_2338, class_1542> findClosestItem(class_1937 world, class_2338 origin) {
        Pair pair;
        Object v0;
        block3: {
            class_238 searchArea = new class_238(origin).method_1009((double)this.getSearchRadius(), (double)this.getSearchHeight(), (double)this.getSearchRadius());
            List items = world.method_8390(class_1542.class, searchArea, arg_0 -> GroundItemGatherer.findClosestItem$lambda$1(GroundItemGatherer::findClosestItem$lambda$0, arg_0));
            Intrinsics.checkNotNull((Object)items);
            Iterable iterable = items;
            for (Object t : iterable) {
                class_1542 item = (class_1542)t;
                boolean bl = false;
                if (!item.method_24828()) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        class_1542 class_15422 = v0;
        if (class_15422 != null) {
            class_1542 it = class_15422;
            boolean bl = false;
            pair = TuplesKt.to((Object)it.method_24515(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    private final boolean isDesignatedGatherer(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getGroundItemGatherers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean findClosestItem$lambda$0(class_1542 it) {
        return true;
    }

    private static final boolean findClosestItem$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

