/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4481;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000fJ;\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001a\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000fJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\bJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R&\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R&\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0'0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020,0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010&R\u0014\u00100\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001a\u00102\u001a\u0002018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R,\u00106\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Laccieo/cobbleworkers/jobs/HoneyCollector;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "origin", "", "tick", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleHarvesting", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "beehivePos", "generateHoney", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)V", "handleGeneration", "Lkotlin/Function2;", "predicate", "findClosestBeehive", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lkotlin/jvm/functions/Function2;)Lnet/minecraft/class_2338;", "harvestHoneycomb", "isAllowedBySpecies", "isDesignatedCollector", "", "", "VALID_SPECIES", "Ljava/util/Set;", "", "Ljava/util/UUID;", "", "Lnet/minecraft/class_1799;", "heldItemsByPokemon", "Ljava/util/Map;", "", "failedDepositLocations", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HoneyGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HoneyGroup;", "", "lastGenerationTime", "getCooldownTicks", "()J", "cooldownTicks", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nHoneyCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoneyCollector.kt\naccieo/cobbleworkers/jobs/HoneyCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n774#2:186\n865#2,2:187\n2423#2,14:189\n1761#2,3:203\n*S KotlinDebug\n*F\n+ 1 HoneyCollector.kt\naccieo/cobbleworkers/jobs/HoneyCollector\n*L\n153#1:186\n153#1:187,2\n154#1:189,14\n183#1:203,3\n*E\n"})
public final class HoneyCollector
implements Worker {
    @NotNull
    public static final HoneyCollector INSTANCE = new HoneyCollector();
    @NotNull
    private static final Set<String> VALID_SPECIES;
    @NotNull
    private static final Map<UUID, List<class_1799>> heldItemsByPokemon;
    @NotNull
    private static final Map<UUID, Set<class_2338>> failedDepositLocations;
    @NotNull
    private static final CobbleworkersConfig.HoneyGroup config;
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime;
    @NotNull
    private static final JobType jobType;
    @NotNull
    private static final Function2<class_1937, class_2338, Boolean> blockValidator;

    private HoneyCollector() {
    }

    private final long getCooldownTicks() {
        return config.getHoneyGenerationCooldownSeconds() * 20L;
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<class_1937, class_2338, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getHoneyCollectorsEnabled()) {
            return false;
        }
        return this.isAllowedBySpecies(pokemonEntity) || this.isDesignatedCollector(pokemonEntity) || CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeHarvestsHoney(), pokemonEntity);
    }

    @Override
    public void tick(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<class_1799> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            if (!this.handleHarvesting(world, origin, pokemonEntity)) {
                this.handleGeneration(world, origin, pokemonEntity);
            }
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    private final boolean handleHarvesting(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        class_2338 class_23382 = this.findClosestBeehive(world, origin, (Function2<? super class_1937, ? super class_2338, Boolean>)((Function2)HoneyCollector::handleHarvesting$lambda$1));
        if (class_23382 == null) {
            return false;
        }
        class_2338 closestBeehive = class_23382;
        Intrinsics.checkNotNull((Object)pokemonId);
        class_2338 currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestBeehive, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestBeehive, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestBeehive, world);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestBeehive)) {
            class_2338 class_23383 = closestBeehive.method_10074();
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"down(...)");
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, class_23383, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            this.harvestHoneycomb(world, closestBeehive, pokemonEntity);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
        return true;
    }

    private final void generateHoney(class_1937 world, class_2338 beehivePos) {
        Integer currentLevel;
        class_2680 state = world.method_8320(beehivePos);
        class_2248 block = state.method_26204();
        if (block instanceof class_4481 && (currentLevel = (Integer)state.method_11654((class_2769)class_4481.field_20420)) < 5) {
            world.method_8652(beehivePos, (class_2680)state.method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(currentLevel + 1)), 3);
        }
    }

    private final void handleGeneration(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        long lastTime;
        if (!config.getCombeeLineGeneratesHoney()) {
            return;
        }
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        long now = world.method_8510();
        Long l = lastGenerationTime.get(pokemonId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getCooldownTicks()) {
            return;
        }
        class_2338 class_23382 = this.findClosestBeehive(world, origin, (Function2<? super class_1937, ? super class_2338, Boolean>)((Function2)HoneyCollector::handleGeneration$lambda$2));
        if (class_23382 == null) {
            return;
        }
        class_2338 closestBeehive = class_23382;
        class_2338 class_23383 = closestBeehive.method_10074();
        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"down(...)");
        if (CobbleworkersNavigationUtils.INSTANCE.isPokemonAtPosition(pokemonEntity, class_23383, 2.0)) {
            this.generateHoney(world, closestBeehive);
            Long l3 = now;
            lastGenerationTime.put(pokemonId, l3);
        } else {
            class_2338 class_23384 = closestBeehive.method_10074();
            Intrinsics.checkNotNullExpressionValue((Object)class_23384, (String)"down(...)");
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, class_23384, 0.0, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final class_2338 findClosestBeehive(class_1937 world, class_2338 origin, Function2<? super class_1937, ? super class_2338, Boolean> predicate) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<class_2338> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 pos = (class_2338)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)predicate.invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_2338 it = (class_2338)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_10262((class_2382)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    class_2338 it2 = (class_2338)e$iv;
                    $i$a$-minByOrNull-HoneyCollector$findClosestBeehive$2 = false;
                    double v$iv = it2.method_10262((class_2382)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final void harvestHoneycomb(class_1937 world, class_2338 beehivePos, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        class_2680 beehiveState = world.method_8320(beehivePos);
        heldItemsByPokemon.put(pokemonId, CollectionsKt.listOf((Object)new class_1799((class_1935)class_1802.field_20414, 3)));
        world.method_8652(beehivePos, (class_2680)beehiveState.method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(0)), 3);
    }

    private final boolean isAllowedBySpecies(PokemonEntity pokemonEntity) {
        if (!config.getCombeeLineCollectsHoney()) {
            return false;
        }
        String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String speciesName = string2;
        return VALID_SPECIES.contains(speciesName);
    }

    private final boolean isDesignatedCollector(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getHoneyCollectors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean blockValidator$lambda$0(class_1937 world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof class_4481;
    }

    private static final boolean handleHarvesting$lambda$1(class_1937 world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Integer n = (Integer)world.method_8320(pos).method_11654((class_2769)class_4481.field_20420);
        int n2 = 5;
        return n != null && n == n2;
    }

    private static final boolean handleGeneration$lambda$2(class_1937 world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return ((Number)((Object)world.method_8320(pos).method_11654((class_2769)class_4481.field_20420))).intValue() < 5;
    }

    static {
        Object[] objectArray = new String[]{"combee", "vespiquen"};
        VALID_SPECIES = SetsKt.setOf((Object[])objectArray);
        heldItemsByPokemon = new LinkedHashMap();
        failedDepositLocations = new LinkedHashMap();
        config = CobbleworkersConfigHolder.INSTANCE.getConfig().getHoney();
        lastGenerationTime = new LinkedHashMap();
        jobType = JobType.HoneyCollector;
        blockValidator = HoneyCollector::blockValidator$lambda$0;
    }
}

