/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9294;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J;\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010 \u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b \u0010\u000fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\bJ\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\bJ\u0017\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&R&\u0010*\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150)0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R&\u0010-\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0,0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010+R\u0014\u00101\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00108\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010:\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00107R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020;0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010+R\u001a\u0010>\u001a\u00020=8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010AR.\u0010C\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010B8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Laccieo/cobbleworkers/jobs/Scout;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "origin", "", "tick", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lkotlin/Pair;", "Lnet/minecraft/class_1542;", "findClosestItem", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Lkotlin/Pair;", "Lnet/minecraft/class_3218;", "Lnet/minecraft/class_1799;", "createStructureMap", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_2960;", "structure", "pos", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/class_6880;", "Lnet/minecraft/class_3195;", "locateStructure", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2960;Lnet/minecraft/class_2338;)Lcom/mojang/datafixers/util/Pair;", "handleGathering", "isDesignatedScout", "doesPokemonKnowFly", "", "rawName", "cleanMapName", "(Ljava/lang/String;)Ljava/lang/String;", "", "Ljava/util/UUID;", "", "heldItemsByPokemon", "Ljava/util/Map;", "", "failedDepositLocations", "Laccieo/cobbleworkers/config/CobbleworkersConfig$ScoutGroup;", "getConfig", "()Laccieo/cobbleworkers/config/CobbleworkersConfig$ScoutGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "generalConfig", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "", "getSearchRadius", "()I", "searchRadius", "getSearchHeight", "searchHeight", "", "lastGenerationTime", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nScout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scout.kt\naccieo/cobbleworkers/jobs/Scout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n774#2:229\n865#2,2:230\n2423#2,14:232\n1761#2,3:247\n1761#2,3:250\n1#3:246\n*S KotlinDebug\n*F\n+ 1 Scout.kt\naccieo/cobbleworkers/jobs/Scout\n*L\n97#1:229\n97#1:230,2\n98#1:232,14\n207#1:247,3\n214#1:250,3\n*E\n"})
public final class Scout
implements Worker {
    @NotNull
    public static final Scout INSTANCE = new Scout();
    @NotNull
    private static final Map<UUID, List<class_1799>> heldItemsByPokemon = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Set<class_2338>> failedDepositLocations = new LinkedHashMap();
    @NotNull
    private static final CobbleworkersConfig.GeneralGroup generalConfig = CobbleworkersConfigHolder.INSTANCE.getConfig().getGeneral();
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime = new LinkedHashMap();
    @NotNull
    private static final JobType jobType = JobType.Scout;
    @Nullable
    private static final Function2<class_1937, class_2338, Boolean> blockValidator;

    private Scout() {
    }

    private final CobbleworkersConfig.ScoutGroup getConfig() {
        return CobbleworkersConfigHolder.INSTANCE.getConfig().getScouts();
    }

    private final int getSearchRadius() {
        return generalConfig.getSearchRadius();
    }

    private final int getSearchHeight() {
        return generalConfig.getSearchHeight();
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @Nullable
    public Function2<class_1937, class_2338, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!this.getConfig().getScoutsEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(this.getConfig().getTypeScouts(), pokemonEntity) || this.isDesignatedScout(pokemonEntity) || this.doesPokemonKnowFly(pokemonEntity);
    }

    @Override
    public void tick(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity) {
        long lastTime;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        UUID uUID = pokemonEntity.method_6139();
        if (uUID == null) {
            return;
        }
        UUID ownerId = uUID;
        List<class_1799> heldItems = heldItemsByPokemon.get(pokemonId);
        long now = world.method_8510();
        Long l = lastGenerationTime.get(ownerId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getConfig().getScoutGenerationCooldownSeconds()) {
            return;
        }
        Long l3 = now;
        lastGenerationTime.put(ownerId, l3);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            this.handleGathering(world, origin, pokemonEntity);
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<class_2338, class_1542> findClosestItem(class_1937 world, class_2338 origin) {
        Pair pair;
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        class_238 searchArea = new class_238(origin).method_1009((double)this.getSearchRadius(), (double)this.getSearchHeight(), (double)this.getSearchRadius());
        List items = world.method_8390(class_1542.class, searchArea, arg_0 -> Scout.findClosestItem$lambda$1(Scout::findClosestItem$lambda$0, arg_0));
        Intrinsics.checkNotNull((Object)items);
        Iterable iterable = items;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_1542 item = (class_1542)element$iv$iv;
            boolean bl = false;
            if (!(item.method_24828() && Intrinsics.areEqual((Object)item.method_6983().method_7909(), (Object)class_1802.field_8895))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_1542 item = (class_1542)minElem$iv;
                boolean bl = false;
                double minValue$iv = item.method_5649((double)origin.method_10263() + 0.5, (double)origin.method_10264() + 0.5, (double)origin.method_10260() + 0.5);
                do {
                    Object e$iv = iterator$iv.next();
                    class_1542 item2 = (class_1542)e$iv;
                    $i$a$-minByOrNull-Scout$findClosestItem$2 = false;
                    double v$iv = item2.method_5649((double)origin.method_10263() + 0.5, (double)origin.method_10264() + 0.5, (double)origin.method_10260() + 0.5);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        class_1542 class_15422 = v0;
        if (class_15422 != null) {
            class_1542 it = class_15422;
            boolean bl = false;
            pair = TuplesKt.to((Object)it.method_24515(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    private final class_1799 createStructureMap(class_3218 world, class_2338 origin) {
        class_2561 class_25612;
        com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> searchResult;
        long now = world.method_8510();
        Set<class_2960> structures = CobbleworkersCacheManager.INSTANCE.getStructures(world, this.getConfig().getUseAllStructures(), this.getConfig().getStructureTags());
        if (structures.isEmpty()) {
            return null;
        }
        class_2960 selectedId = (class_2960)CollectionsKt.random((Collection)structures, (Random)((Random)Random.Default));
        com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> cached = CobbleworkersCacheManager.INSTANCE.getCachedStructure(selectedId, now);
        com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> pair = cached;
        if (pair == null) {
            com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> pair2 = this.locateStructure(world, selectedId, origin);
            if (pair2 != null) {
                com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> pair3;
                com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> it = pair3 = pair2;
                boolean bl = false;
                CobbleworkersCacheManager.INSTANCE.cacheStructure(selectedId, it, now);
                pair = pair3;
            } else {
                pair = null;
            }
        }
        if ((searchResult = pair) == null) {
            return null;
        }
        class_2338 structurePos = (class_2338)searchResult.getFirst();
        class_6880 structureEntry = (class_6880)searchResult.getSecond();
        class_1799 map = class_1806.method_8005((class_1937)((class_1937)world), (int)structurePos.method_10263(), (int)structurePos.method_10260(), (byte)2, (boolean)true, (boolean)true);
        class_22.method_110((class_1799)map, (class_2338)structurePos, (String)"target", (class_6880)class_21.field_110);
        if (this.getConfig().getMapNameIsHidden()) {
            class_25612 = class_2561.method_30163((String)"Scout's map");
        } else {
            String string = structureEntry.method_55840();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdAsString(...)");
            class_25612 = class_2561.method_30163((String)this.cleanMapName(string));
        }
        class_2561 mapKey = class_25612;
        map.method_57379(class_9334.field_49631, (Object)mapKey);
        map.method_57379(class_9334.field_49645, (Object)new class_9294(13403373));
        return map;
    }

    private final com.mojang.datafixers.util.Pair<class_2338, class_6880<class_3195>> locateStructure(class_3218 world, class_2960 structure, class_2338 pos) {
        class_2378 structureRegistry = world.method_8503().method_30611().method_30530(class_7924.field_41246);
        class_6880.class_6883 class_68832 = structureRegistry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)structure)).orElse(null);
        if (class_68832 == null) {
            return null;
        }
        class_6880.class_6883 entry = class_68832;
        class_6880[] class_6880Array = new class_6880[]{entry};
        class_6885.class_6886 entryList = class_6885.method_40246((class_6880[])class_6880Array);
        class_2794 chunkGenerator = world.method_14178().method_12129();
        return chunkGenerator.method_12103(world, (class_6885)entryList, pos, 100, false);
    }

    private final void handleGathering(class_1937 world, class_2338 origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        Pair<class_2338, class_1542> pair = this.findClosestItem(world, origin);
        if (pair == null) {
            return;
        }
        Pair<class_2338, class_1542> pair2 = pair;
        class_2338 closestItemPos = (class_2338)pair2.component1();
        class_1542 closestItem = (class_1542)pair2.component2();
        Intrinsics.checkNotNull((Object)pokemonId);
        class_2338 currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestItemPos, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestItemPos, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestItemPos, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestItemPos)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestItemPos, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            if (Intrinsics.areEqual((Object)closestItem.method_6983().method_7909(), (Object)class_1802.field_8895)) {
                class_1799 singleItem = closestItem.method_6983().method_7971(1);
                if (closestItem.method_6983().method_7960()) {
                    closestItem.method_31472();
                }
                Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                class_1799 map = this.createStructureMap((class_3218)world, origin);
                if (map != null) {
                    heldItemsByPokemon.put(pokemonId, CollectionsKt.listOf((Object)map));
                } else {
                    heldItemsByPokemon.put(pokemonId, CollectionsKt.listOf((Object)singleItem));
                }
            }
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    private final boolean isDesignatedScout(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = this.getConfig().getScouts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean doesPokemonKnowFly(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = pokemonEntity.getPokemon().getMoveSet().getMoves();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"fly")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String cleanMapName(String rawName) {
        String[] stringArray = new String[]{" "};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)StringsKt.substringAfterLast$default((String)rawName, (String)":", null, (int)2, null), (String)"/", null, (int)2, null), (String)"_", (String)" ", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, Scout::cleanMapName$lambda$9, (int)30, null);
    }

    private static final boolean findClosestItem$lambda$0(class_1542 it) {
        return true;
    }

    private static final boolean findClosestItem$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence cleanMapName$lambda$9(String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it;
        if (((CharSequence)string2).length() > 0) {
            void c;
            char c2 = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)c);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }
}

