/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.mixin;

import accieo.cobbleworkers.Cobbleworkers;
import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.jobs.WorkerDispatcher;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public class PokemonPastureBlockEntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"TICKER$lambda$0"})
    private static void init(class_1937 world, class_2338 blockPos, class_2680 blockState, PokemonPastureBlockEntity pastureBlock, CallbackInfo ci) {
        if (world.field_9236) {
            return;
        }
        try {
            WorkerDispatcher.INSTANCE.tickAreaScan(world, blockPos);
        }
        catch (Exception e) {
            Cobbleworkers.LOGGER.error("[Cobbleworkers] - Error processing WorkerDispatcher tickAreaScan", (Throwable)e);
        }
        pastureBlock.getTetheredPokemon().stream().filter(Objects::nonNull).forEach(tethering -> {
            Pokemon pokemon;
            try {
                pokemon = tethering.getPokemon();
            }
            catch (Exception e) {
                Cobbleworkers.LOGGER.error("[Cobbleworkers] - Failed to get Pok\u00e9mon from tethering: {}", (Object)e.getMessage());
                return;
            }
            if (pokemon == null || pokemon.isFainted()) {
                return;
            }
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity == null) {
                return;
            }
            try {
                WorkerDispatcher.INSTANCE.tickPokemon(world, blockPos, pokemonEntity);
            }
            catch (Exception e) {
                Cobbleworkers.LOGGER.error("[Cobbleworkers] - Error processing WorkerDispatcher.tickPokemon {}", (Object)e.getMessage());
            }
        });
    }

    @Inject(method={"onBroken()V"}, at={@At(value="TAIL")}, remap=false)
    private void onPastureBroken(CallbackInfo ci) {
        PokemonPastureBlockEntity self = (PokemonPastureBlockEntity)this;
        class_1937 world = self.method_10997();
        if (world != null && !world.field_9236) {
            CobbleworkersCacheManager.INSTANCE.removePasture(self.method_11016());
        }
    }
}

