/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.DeferredBlockScanner;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010 Jg\u0010+\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010$\u001a\u00020#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0(0&2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190&\u00a2\u0006\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils;", "", "<init>", "()V", "", "Lnet/minecraft/class_2248;", "externalBlocks", "", "addCompatibility", "(Ljava/util/Set;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "pos", "", "blockValidator", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Z", "origin", "ignorePos", "findClosestInventory", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ljava/util/Set;)Lnet/minecraft/class_2338;", "Lnet/minecraft/class_1263;", "inventory", "getActualInventory", "(Lnet/minecraft/class_1263;)Lnet/minecraft/class_1263;", "", "Lnet/minecraft/class_1799;", "stacks", "insertStacks", "(Lnet/minecraft/class_1263;Ljava/util/List;)Ljava/util/List;", "stack", "insertStack", "(Lnet/minecraft/class_1263;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "fillEmptySlots", "fillExistingStacks", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "itemsToDeposit", "", "Ljava/util/UUID;", "", "failedDepositLocations", "heldItemsByPokemon", "handleDepositing", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "validInventoryBlocks", "Ljava/util/Set;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nCobbleworkersInventoryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleworkersInventoryUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,229:1\n774#2:230\n865#2,2:231\n2423#2,14:233\n1869#2,2:247\n1869#2,2:256\n384#3,7:249\n*S KotlinDebug\n*F\n+ 1 CobbleworkersInventoryUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils\n*L\n64#1:230\n64#1:231,2\n67#1:233,14\n94#1:247,2\n197#1:256,2\n186#1:249,7\n*E\n"})
public final class CobbleworkersInventoryUtils {
    @NotNull
    public static final CobbleworkersInventoryUtils INSTANCE = new CobbleworkersInventoryUtils();
    @NotNull
    private static final Set<class_2248> validInventoryBlocks;

    private CobbleworkersInventoryUtils() {
    }

    public final void addCompatibility(@NotNull Set<? extends class_2248> externalBlocks) {
        Intrinsics.checkNotNullParameter(externalBlocks, (String)"externalBlocks");
        validInventoryBlocks.addAll((Collection<class_2248>)externalBlocks);
    }

    public final boolean blockValidator(@NotNull class_1937 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_2680 state = world.method_8320(pos);
        return validInventoryBlocks.contains(state.method_26204());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final class_2338 findClosestInventory(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull Set<? extends class_2338> ignorePos) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(ignorePos, (String)"ignorePos");
        Set<class_2338> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, JobType.Generic);
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 pos = (class_2338)element$iv$iv;
            boolean bl = false;
            if (!(INSTANCE.blockValidator(world, pos) && !ignorePos.contains(pos))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_2338 it = (class_2338)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_10262((class_2382)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    class_2338 it2 = (class_2338)e$iv;
                    $i$a$-minByOrNull-CobbleworkersInventoryUtils$findClosestInventory$2 = false;
                    double v$iv = it2.method_10262((class_2382)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ class_2338 findClosestInventory$default(CobbleworkersInventoryUtils cobbleworkersInventoryUtils, class_1937 class_19372, class_2338 class_23382, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        return cobbleworkersInventoryUtils.findClosestInventory(class_19372, class_23382, set);
    }

    @NotNull
    public final class_1263 getActualInventory(@NotNull class_1263 inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        if (!(inventory instanceof class_2595)) {
            return inventory;
        }
        class_1937 class_19372 = ((class_2595)inventory).method_10997();
        if (class_19372 == null) {
            return inventory;
        }
        class_1937 world = class_19372;
        class_2338 pos = ((class_2595)inventory).method_11016();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2281) {
            class_1263 class_12632 = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)state, (class_1937)world, (class_2338)pos, (boolean)true);
            if (class_12632 == null) {
                class_12632 = inventory;
            }
            return class_12632;
        }
        return inventory;
    }

    @NotNull
    public final List<class_1799> insertStacks(@NotNull class_1263 inventory, @NotNull List<class_1799> stacks) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter(stacks, (String)"stacks");
        class_1263 actualInventory = this.getActualInventory(inventory);
        List remainingDrops = new ArrayList();
        Iterable $this$forEach$iv = stacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1799 stack = (class_1799)element$iv;
            boolean bl = false;
            class_1799 class_17992 = stack.method_7972();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"copy(...)");
            class_1799 remaining = INSTANCE.insertStack(actualInventory, class_17992);
            if (remaining.method_7960()) continue;
            remainingDrops.add(remaining);
        }
        return remainingDrops;
    }

    @NotNull
    public final class_1799 insertStack(@NotNull class_1263 inventory, @NotNull class_1799 stack) {
        class_1799 remainingStack;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.method_7960()) {
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
        class_1799 class_17993 = remainingStack = stack.method_7972();
        Intrinsics.checkNotNull((Object)class_17993);
        remainingStack = this.fillExistingStacks(inventory, class_17993);
        if (!remainingStack.method_7960()) {
            remainingStack = this.fillEmptySlots(inventory, remainingStack);
        }
        return remainingStack;
    }

    private final class_1799 fillEmptySlots(class_1263 inventory, class_1799 stack) {
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            if (inventory.method_5438(i).method_7960()) {
                int toTransfer = Math.min(stack.method_7947(), stack.method_7914());
                inventory.method_5447(i, stack.method_7971(toTransfer));
                inventory.method_5431();
            }
            if (!stack.method_7960()) continue;
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
        return stack;
    }

    private final class_1799 fillExistingStacks(class_1263 inventory, class_1799 stack) {
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960() || !class_1799.method_31577((class_1799)inventoryStack, (class_1799)stack)) continue;
            int availableSpace = inventoryStack.method_7914() - inventoryStack.method_7947();
            if (availableSpace > 0) {
                int toTransfer = Math.min(stack.method_7947(), availableSpace);
                inventoryStack.method_7933(toTransfer);
                stack.method_7934(toTransfer);
                inventory.method_5431();
            }
            if (!stack.method_7960()) continue;
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
        return stack;
    }

    public final void handleDepositing(@NotNull class_1937 world, @NotNull class_2338 origin, @NotNull PokemonEntity pokemonEntity, @NotNull List<class_1799> itemsToDeposit, @NotNull Map<UUID, Set<class_2338>> failedDepositLocations, @NotNull Map<UUID, List<class_1799>> heldItemsByPokemon) {
        Set triedPositions;
        class_2338 inventoryPos;
        Set set;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter(itemsToDeposit, (String)"itemsToDeposit");
        Intrinsics.checkNotNullParameter(failedDepositLocations, (String)"failedDepositLocations");
        Intrinsics.checkNotNullParameter(heldItemsByPokemon, (String)"heldItemsByPokemon");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        Map<UUID, Set<class_2338>> $this$getOrPut$iv = failedDepositLocations;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(pokemonId);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(pokemonId, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        if ((inventoryPos = this.findClosestInventory(world, origin, triedPositions = set)) == null) {
            if (DeferredBlockScanner.INSTANCE.isScanActive(origin)) {
                heldItemsByPokemon.put(pokemonId, itemsToDeposit);
                return;
            }
            Iterable $this$forEach$iv = itemsToDeposit;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_1799 stack = (class_1799)element$iv;
                boolean bl = false;
                class_2248.method_9577((class_1937)world, (class_2338)pokemonEntity.method_24515(), (class_1799)stack);
            }
            heldItemsByPokemon.remove(pokemonId);
            failedDepositLocations.remove(pokemonId);
            return;
        }
        if (CobbleworkersNavigationUtils.INSTANCE.isPokemonAtPosition(pokemonEntity, inventoryPos, 2.0)) {
            class_1263 inventory;
            class_2586 $i$f$forEach = world.method_8321(inventoryPos);
            class_1263 class_12632 = inventory = $i$f$forEach instanceof class_1263 ? (class_1263)$i$f$forEach : null;
            if (inventory == null) {
                triedPositions.add(inventoryPos);
                return;
            }
            List<class_1799> remainingDrops = this.insertStacks(inventory, itemsToDeposit);
            if (remainingDrops.size() == itemsToDeposit.size()) {
                triedPositions.add(inventoryPos);
            }
            if (!((Collection)remainingDrops).isEmpty()) {
                heldItemsByPokemon.put(pokemonId, remainingDrops);
            } else {
                heldItemsByPokemon.remove(pokemonId);
                failedDepositLocations.remove(pokemonId);
                pokemonEntity.getNavigation().method_6340();
            }
        } else {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, inventoryPos, 0.0, 4, null);
        }
    }

    static {
        Object[] objectArray = new class_2248[]{class_2246.field_10034, class_2246.field_10380, class_2246.field_16328, CobblemonBlocks.GILDED_CHEST, CobblemonBlocks.BLUE_GILDED_CHEST, CobblemonBlocks.PINK_GILDED_CHEST, CobblemonBlocks.BLACK_GILDED_CHEST, CobblemonBlocks.WHITE_GILDED_CHEST, CobblemonBlocks.GREEN_GILDED_CHEST, CobblemonBlocks.YELLOW_GILDED_CHEST};
        validInventoryBlocks = SetsKt.mutableSetOf((Object[])objectArray);
    }
}

