/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.mixin.BrewingStandBlockEntityAccessor;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\bR\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R,\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Laccieo/cobbleworkers/jobs/BrewingStandFuelGenerator;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "findClosestBrewingStand", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "handleFuelGeneration", "standPos", "addBurnTime", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "isDesignatedGenerator", "Laccieo/cobbleworkers/config/CobbleworkersConfig$BrewingStandFuelGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$BrewingStandFuelGroup;", "", "getCooldownTicks", "()J", "cooldownTicks", "", "Ljava/util/UUID;", "lastGenerationTime", "Ljava/util/Map;", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nBrewingStandFuelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrewingStandFuelGenerator.kt\naccieo/cobbleworkers/jobs/BrewingStandFuelGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n774#2:131\n865#2,2:132\n2423#2,14:134\n1761#2,3:148\n*S KotlinDebug\n*F\n+ 1 BrewingStandFuelGenerator.kt\naccieo/cobbleworkers/jobs/BrewingStandFuelGenerator\n*L\n66#1:131\n66#1:132,2\n72#1:134,14\n128#1:148,3\n*E\n"})
public final class BrewingStandFuelGenerator
implements Worker {
    @NotNull
    public static final BrewingStandFuelGenerator INSTANCE = new BrewingStandFuelGenerator();
    @NotNull
    private static final CobbleworkersConfig.BrewingStandFuelGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getBrewingStandFuel();
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime = new LinkedHashMap();
    @NotNull
    private static final JobType jobType = JobType.BrewingStandFuelGenerator;
    @NotNull
    private static final Function2<Level, BlockPos, Boolean> blockValidator = BrewingStandFuelGenerator::blockValidator$lambda$0;

    private BrewingStandFuelGenerator() {
    }

    private final long getCooldownTicks() {
        return config.getFuelGenerationCooldownSeconds() * 20L;
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<Level, BlockPos, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getFuelGeneratorsEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeGeneratesFuel(), pokemonEntity) || this.isDesignatedGenerator(pokemonEntity);
    }

    @Override
    public void tick(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        this.handleFuelGeneration(world, origin, pokemonEntity);
    }

    /*
     * Unable to fully structure code
     */
    private final BlockPos findClosestBrewingStand(Level world, BlockPos origin) {
        possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        var4_4 = possibleTargets;
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            pos = (BlockPos)element$iv$iv;
            $i$a$-filter-BrewingStandFuelGenerator$findClosestBrewingStand$1 = false;
            blockEntity = world.getBlockEntity(pos);
            if (!((Boolean)BrewingStandFuelGenerator.INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos)).booleanValue() || CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type accieo.cobbleworkers.mixin.BrewingStandBlockEntityAccessor");
            if (((BrewingStandBlockEntityAccessor)blockEntity).getFuel() < 20) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                it = (BlockPos)minElem$iv;
                $i$a$-minByOrNull-BrewingStandFuelGenerator$findClosestBrewingStand$2 = false;
                minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    e$iv = iterator$iv.next();
                    it = (BlockPos)e$iv;
                    $i$a$-minByOrNull-BrewingStandFuelGenerator$findClosestBrewingStand$2 = false;
                    v$iv = it.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        return v1;
    }

    private final void handleFuelGeneration(Level world, BlockPos origin, PokemonEntity pokemonEntity) {
        long lastTime;
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        BlockPos blockPos = this.findClosestBrewingStand(world, origin);
        if (blockPos == null) {
            return;
        }
        BlockPos closestBrewingStand = blockPos;
        long now = world.getGameTime();
        Long l = lastGenerationTime.get(pokemonId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getCooldownTicks()) {
            return;
        }
        Intrinsics.checkNotNull((Object)pokemonId);
        BlockPos currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestBrewingStand, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestBrewingStand, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestBrewingStand, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestBrewingStand)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestBrewingStand, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestBrewingStand, 0.0, 4, null)) {
            this.addBurnTime(world, closestBrewingStand);
            Long l3 = now;
            lastGenerationTime.put(pokemonId, l3);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    private final void addBurnTime(Level world, BlockPos standPos) {
        BlockEntity blockEntity = world.getBlockEntity(standPos);
        if (!(blockEntity instanceof BrewingStandBlockEntity)) {
            return;
        }
        BrewingStandBlockEntityAccessor accessor = (BrewingStandBlockEntityAccessor)blockEntity;
        int addedFuel = RangesKt.coerceAtMost((int)(accessor.getFuel() + config.getAddedFuel()), (int)20);
        accessor.setFuel(addedFuel);
        ((BrewingStandBlockEntity)blockEntity).setChanged();
        world.sendBlockUpdated(standPos, world.getBlockState(standPos), world.getBlockState(standPos), 3);
    }

    private final boolean isDesignatedGenerator(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getFuelGenerators();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean blockValidator$lambda$0(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return state.getBlock() instanceof BrewingStandBlock && blockEntity instanceof BrewingStandBlockEntity;
    }
}

