/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000fJ;\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001a\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000fJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\bJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R&\u0010*\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R&\u0010-\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0,0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010+R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R \u00102\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002010&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010+R\u0014\u00105\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00107\u001a\u0002068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R,\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Laccieo/cobbleworkers/jobs/HoneyCollector;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleHarvesting", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "beehivePos", "generateHoney", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "handleGeneration", "Lkotlin/Function2;", "predicate", "findClosestBeehive", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function2;)Lnet/minecraft/core/BlockPos;", "harvestHoneycomb", "isAllowedBySpecies", "isDesignatedCollector", "", "", "VALID_SPECIES", "Ljava/util/Set;", "VALID_TRANSLATED_SPECIES$delegate", "Lkotlin/Lazy;", "getVALID_TRANSLATED_SPECIES", "()Ljava/util/Set;", "VALID_TRANSLATED_SPECIES", "", "Ljava/util/UUID;", "", "Lnet/minecraft/world/item/ItemStack;", "heldItemsByPokemon", "Ljava/util/Map;", "", "failedDepositLocations", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HoneyGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$HoneyGroup;", "", "lastGenerationTime", "getCooldownTicks", "()J", "cooldownTicks", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nHoneyCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoneyCollector.kt\naccieo/cobbleworkers/jobs/HoneyCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n774#2:196\n865#2,2:197\n2423#2,14:199\n1761#2,3:213\n1563#2:216\n1634#2,3:217\n*S KotlinDebug\n*F\n+ 1 HoneyCollector.kt\naccieo/cobbleworkers/jobs/HoneyCollector\n*L\n163#1:196\n163#1:197,2\n164#1:199,14\n193#1:213,3\n35#1:216\n35#1:217,3\n*E\n"})
public final class HoneyCollector
implements Worker {
    @NotNull
    public static final HoneyCollector INSTANCE = new HoneyCollector();
    @NotNull
    private static final Set<String> VALID_SPECIES;
    @NotNull
    private static final Lazy VALID_TRANSLATED_SPECIES$delegate;
    @NotNull
    private static final Map<UUID, List<ItemStack>> heldItemsByPokemon;
    @NotNull
    private static final Map<UUID, Set<BlockPos>> failedDepositLocations;
    @NotNull
    private static final CobbleworkersConfig.HoneyGroup config;
    @NotNull
    private static final Map<UUID, Long> lastGenerationTime;
    @NotNull
    private static final JobType jobType;
    @NotNull
    private static final Function2<Level, BlockPos, Boolean> blockValidator;

    private HoneyCollector() {
    }

    private final Set<String> getVALID_TRANSLATED_SPECIES() {
        Lazy lazy = VALID_TRANSLATED_SPECIES$delegate;
        return (Set)lazy.getValue();
    }

    private final long getCooldownTicks() {
        return config.getHoneyGenerationCooldownSeconds() * 20L;
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<Level, BlockPos, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getHoneyCollectorsEnabled()) {
            return false;
        }
        return this.isAllowedBySpecies(pokemonEntity) || this.isDesignatedCollector(pokemonEntity) || CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeHarvestsHoney(), pokemonEntity);
    }

    @Override
    public void tick(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<ItemStack> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            if (!this.handleHarvesting(world, origin, pokemonEntity)) {
                this.handleGeneration(world, origin, pokemonEntity);
            }
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    private final boolean handleHarvesting(Level world, BlockPos origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        BlockPos blockPos = this.findClosestBeehive(world, origin, (Function2<? super Level, ? super BlockPos, Boolean>)((Function2)HoneyCollector::handleHarvesting$lambda$3));
        if (blockPos == null) {
            return false;
        }
        BlockPos closestBeehive = blockPos;
        Intrinsics.checkNotNull((Object)pokemonId);
        BlockPos currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestBeehive, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestBeehive, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestBeehive, world);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestBeehive)) {
            BlockPos blockPos2 = closestBeehive.below();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"down(...)");
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, blockPos2, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.isPokemonAtPosition$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, currentTarget, 0.0, 4, null)) {
            this.harvestHoneycomb(world, closestBeehive, pokemonEntity);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
        return true;
    }

    private final void generateHoney(Level world, BlockPos beehivePos) {
        Integer currentLevel;
        BlockState state = world.getBlockState(beehivePos);
        Block block = state.getBlock();
        if (block instanceof BeehiveBlock && (currentLevel = (Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL)) < 5) {
            world.setBlock(beehivePos, (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(currentLevel + 1)), 3);
        }
    }

    private final void handleGeneration(Level world, BlockPos origin, PokemonEntity pokemonEntity) {
        long lastTime;
        if (!config.getCombeeLineGeneratesHoney()) {
            return;
        }
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        long now = world.getGameTime();
        Long l = lastGenerationTime.get(pokemonId);
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime < this.getCooldownTicks()) {
            return;
        }
        BlockPos blockPos = this.findClosestBeehive(world, origin, (Function2<? super Level, ? super BlockPos, Boolean>)((Function2)HoneyCollector::handleGeneration$lambda$4));
        if (blockPos == null) {
            return;
        }
        BlockPos closestBeehive = blockPos;
        BlockPos blockPos2 = closestBeehive.below();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"down(...)");
        if (CobbleworkersNavigationUtils.INSTANCE.isPokemonAtPosition(pokemonEntity, blockPos2, 2.0)) {
            this.generateHoney(world, closestBeehive);
            Long l3 = now;
            lastGenerationTime.put(pokemonId, l3);
        } else {
            BlockPos blockPos3 = closestBeehive.below();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"down(...)");
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, blockPos3, 0.0, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BlockPos findClosestBeehive(Level world, BlockPos origin, Function2<? super Level, ? super BlockPos, Boolean> predicate) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)predicate.invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-HoneyCollector$findClosestBeehive$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final void harvestHoneycomb(Level world, BlockPos beehivePos, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        BlockState beehiveState = world.getBlockState(beehivePos);
        heldItemsByPokemon.put(pokemonId, CollectionsKt.listOf((Object)new ItemStack((ItemLike)Items.HONEYCOMB, 3)));
        world.setBlock(beehivePos, (BlockState)beehiveState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    private final boolean isAllowedBySpecies(PokemonEntity pokemonEntity) {
        if (!config.getCombeeLineCollectsHoney()) {
            return false;
        }
        String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String speciesName = string2;
        return this.getVALID_TRANSLATED_SPECIES().contains(speciesName);
    }

    private final boolean isDesignatedCollector(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getHoneyCollectors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static final Set VALID_TRANSLATED_SPECIES_delegate$lambda$1() {
        $this$map$iv = HoneyCollector.VALID_SPECIES;
        $i$f$map = false;
        var2_2 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var7_7 = (String)item$iv$iv;
            var13_13 = destination$iv$iv;
            $i$a$-map-HoneyCollector$VALID_TRANSLATED_SPECIES$2$1 = false;
            var9_9 = PokemonSpecies.getByName((String)name);
            if (var9_9 == null || (var10_10 = var9_9.getTranslatedName()) == null || (var11_11 = var10_10.getString()) == null) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)var11_11.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (var12_12 != null) {
                v0 = var12_12;
            } else lbl-1000:
            // 2 sources

            {
                v1 = name.toLowerCase(Locale.ROOT);
                v0 = v1;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            }
            var13_13.add(v0);
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    private static final boolean blockValidator$lambda$2(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof BeehiveBlock;
    }

    private static final boolean handleHarvesting$lambda$3(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Integer n = (Integer)world.getBlockState(pos).getValue((Property)BeehiveBlock.HONEY_LEVEL);
        int n2 = 5;
        return n != null && n == n2;
    }

    private static final boolean handleGeneration$lambda$4(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return ((Number)((Object)world.getBlockState(pos).getValue((Property)BeehiveBlock.HONEY_LEVEL))).intValue() < 5;
    }

    static {
        Object[] objectArray = new String[]{"combee", "vespiquen"};
        VALID_SPECIES = SetsKt.setOf((Object[])objectArray);
        VALID_TRANSLATED_SPECIES$delegate = LazyKt.lazy(HoneyCollector::VALID_TRANSLATED_SPECIES_delegate$lambda$1);
        heldItemsByPokemon = new LinkedHashMap();
        failedDepositLocations = new LinkedHashMap();
        config = CobbleworkersConfigHolder.INSTANCE.getConfig().getHoney();
        lastGenerationTime = new LinkedHashMap();
        jobType = JobType.HoneyCollector;
        blockValidator = HoneyCollector::blockValidator$lambda$2;
    }
}

