/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animations.justsit.forge.mixin;

import aquariusplayz.animations.justsit.forge.interfaces.IPlayer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerMixin
extends LivingEntity
implements IPlayer {
    private static final EntityDataAccessor<Boolean> DATA_SITTING = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"}, cancellable=true)
    public void defineSynchedData(SynchedEntityData.Builder p_335298_, CallbackInfo ci) {
        p_335298_.define(DATA_SITTING, (Object)false);
    }

    @Override
    public EntityDataAccessor<Boolean> getDataSitting() {
        return DATA_SITTING;
    }

    @Override
    public boolean isSitting() {
        return (Boolean)this.entityData.get(DATA_SITTING);
    }

    @Override
    public void isSitting(boolean p_36363_) {
        this.entityData.set(DATA_SITTING, (Object)p_36363_);
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"}, cancellable=true)
    public void readAdditionalSaveData(ValueInput p_410352_, CallbackInfo ci) {
        this.isSitting(p_410352_.getBooleanOr("isSitting", false));
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"}, cancellable=true)
    public void addAdditionalSaveData(ValueOutput p_406026_, CallbackInfo ci) {
        p_406026_.putBoolean("isSitting", this.isSitting());
    }

    @Inject(at={@At(value="HEAD")}, method={"getDesiredPose"}, cancellable=true)
    public void getDesiredPose(CallbackInfoReturnable<Pose> ci) {
        if (this.isSitting()) {
            ci.setReturnValue((Object)Pose.SITTING);
            ci.cancel();
        }
    }
}

