/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animations.justsit.forge.networking.client;

import aquariusplayz.animations.justsit.forge.interfaces.IPlayer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;

public class IsSittingPacketFromServer {
    private boolean isSitting;
    private UUID uuid;

    public IsSittingPacketFromServer(FriendlyByteBuf buf) {
        this.isSitting = buf.readBoolean();
        this.uuid = buf.readUUID();
    }

    public IsSittingPacketFromServer(boolean isSitting, UUID uuid) {
        this.isSitting = isSitting;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isSitting);
        buf.writeUUID(this.uuid);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (Player target : Minecraft.getInstance().level.players()) {
            if (!target.getUUID().equals(this.uuid)) continue;
            ((IPlayer)target).isSitting(this.isSitting);
        }
    }
}

