/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animations.justsit.forge.networking.server;

import aquariusplayz.animations.justsit.forge.interfaces.IPlayer;
import aquariusplayz.animations.justsit.forge.networking.Networking;
import aquariusplayz.animations.justsit.forge.networking.client.IsSittingPacketFromServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class IsSittingPacketFromClient {
    private boolean isSitting;

    public IsSittingPacketFromClient(FriendlyByteBuf buf) {
        this.isSitting = buf.readBoolean();
    }

    public IsSittingPacketFromClient(boolean isSitting) {
        this.isSitting = isSitting;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isSitting);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (!sender.level().isClientSide() && ((IPlayer)sender).isSitting() != this.isSitting) {
                ((IPlayer)sender).isSitting(this.isSitting);
                for (Player sp : ctx.getSender().level().players()) {
                    Networking.sendToClient(new IsSittingPacketFromServer(this.isSitting, sender.getUUID()), (ServerPlayer)sp);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

