/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSBoatModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSChestBoatModel;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class JSBoatRenderer
extends class_897<JSBoatEntity> {
    private final Map<JSBoatEntity.CustomType, Pair<class_2960, class_4595<JSBoatEntity>>> boatResources;

    public JSBoatRenderer(class_5617.class_5618 pContext, boolean pChestBoat) {
        super(pContext);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(JSBoatEntity.CustomType.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, modType -> Pair.of((Object)class_2960.method_60655((String)"jurassicsaga", (String)JSBoatRenderer.getTextureLocation(modType, pChestBoat)), this.createBoatModel(pContext, (JSBoatEntity.CustomType)((Object)modType), pChestBoat))));
    }

    private class_4595<JSBoatEntity> createBoatModel(class_5617.class_5618 pContext, JSBoatEntity.CustomType pType, boolean pChestBoat) {
        class_5601 modellayerlocation = pChestBoat ? JSBoatRenderer.createChestBoatModelName(pType) : JSBoatRenderer.createBoatModelName(pType);
        class_630 modelpart = pContext.method_32167(modellayerlocation);
        return pChestBoat ? new JSChestBoatModel(modelpart) : new JSBoatModel(modelpart);
    }

    public static class_5601 createChestBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/chest" + pType.getName());
    }

    public static class_5601 createBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/" + pType.getName());
    }

    private static class_5601 createLocation(String pPath) {
        return new class_5601(class_2960.method_60655((String)"jurassicsaga", (String)pPath), "main");
    }

    private static String getTextureLocation(JSBoatEntity.CustomType pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/boat/chest/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    public void render(JSBoatEntity pEntity, float pEntityYaw, float pPartialTicks, class_4587 pMatrixStack, @NotNull class_4597 pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.method_22903();
        pMatrixStack.method_46416(0.0f, 0.375f, 0.0f);
        pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.method_54295() - pPartialTicks;
        float f1 = pEntity.method_54294() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)pEntity.method_54296()));
        }
        if (!class_3532.method_15347((float)(f2 = pEntity.method_7547(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.method_22907(new Quaternionf().setAngleAxis(pEntity.method_7547(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<JSBoatEntity>> pair = this.getModelWithLocation(pEntity);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_4595 listmodel = (class_4595)pair.getSecond();
        pMatrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listmodel.method_2819((class_1297)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = pBuffer.getBuffer(listmodel.method_23500(resourcelocation));
        listmodel.method_2828(pMatrixStack, vertexconsumer, pPackedLight, class_4608.field_21444, -1);
        if (!pEntity.method_5869()) {
            class_4588 vertexconsumer1 = pBuffer.getBuffer(class_1921.method_23589());
            if (listmodel instanceof class_7755) {
                class_7755 waterpatchmodel = (class_7755)listmodel;
                waterpatchmodel.method_22954().method_22698(pMatrixStack, vertexconsumer1, pPackedLight, class_4608.field_21444);
            }
        }
        pMatrixStack.method_22909();
        super.method_3936((class_1297)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull JSBoatEntity pEntity) {
        return (class_2960)this.getModelWithLocation(pEntity).getFirst();
    }

    public Pair<class_2960, class_4595<JSBoatEntity>> getModelWithLocation(JSBoatEntity boat) {
        return this.boatResources.get((Object)boat.getNWBoatEntityType());
    }
}

