/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.layer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.locator.ResourceLocator;

public class LuxLayer
implements AzRenderLayer<UUID, SmartAnimalBase> {
    public static final Map<UUID, Float> previousBrightness = new HashMap<UUID, Float>();

    public void preRender(AzRendererPipelineContext<UUID, SmartAnimalBase> azRendererPipelineContext) {
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context) {
        Object object = context.animatable();
        if (object instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)((Object)object);
            if (base.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                return;
            }
            if (!base.getModules().getGeneticModule().getGeneData().hasGene(JSGenetics.LUX)) {
                return;
            }
            float brightness = this.getLerpedBrightness(base);
            if (brightness <= 0.0f) {
                return;
            }
            ResourceLocator resourceLocator = base.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator();
            if (resourceLocator instanceof JSAnimalBaseLocator) {
                JSAnimalBaseLocator locator = (JSAnimalBaseLocator)resourceLocator;
                AzRendererPipeline renderPipeline = context.rendererPipeline();
                class_2960 textureLocation = locator.getLuxLocation(base);
                class_1921 renderType = class_1921.method_42600((class_2960)textureLocation);
                class_1921 prevRenderType = context.renderType();
                int prevPackedLight = context.packedLight();
                class_4588 prevVertexConsumer = context.vertexConsumer();
                context.setRenderType(renderType);
                context.setPackedLight(0xF00000);
                context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
                int color = this.getHueShiftColor(base.getModules().getGeneticModule().getGeneData().getGeneSeed(), brightness);
                context.setRenderColor(color);
                renderPipeline.reRender(context);
                context.setRenderType(prevRenderType);
                context.setPackedLight(prevPackedLight);
                context.setVertexConsumer(prevVertexConsumer);
            }
        }
    }

    public float getLerpedBrightness(JSAnimalBase base) {
        UUID id = base.method_5667();
        boolean isDay = base.method_37908().method_8532() % 24000L < 12000L;
        float brightnessSky = isDay ? (float)base.method_37908().method_8314(class_1944.field_9284, base.method_24515()) : 0.0f;
        float brightnessGround = base.method_37908().method_8314(class_1944.field_9282, base.method_24515());
        float blockLight = Math.min(15.0f, brightnessGround + brightnessSky);
        float invertedBlockLight = 15.0f - blockLight;
        float previous = previousBrightness.getOrDefault(id, Float.valueOf(invertedBlockLight)).floatValue();
        float lerped = class_3532.method_16439((float)0.0025f, (float)previous, (float)invertedBlockLight);
        previousBrightness.put(id, Float.valueOf(lerped));
        return lerped;
    }

    public int getHueShiftColor(int seed, float brightness) {
        Random random = new Random(seed);
        float brightnessFactor = class_3532.method_15363((float)(brightness / 15.0f), (float)0.0f, (float)1.0f);
        float hueShift = random.nextFloat();
        float saturation = class_3532.method_16439((float)brightnessFactor, (float)1.0f, (float)(random.nextFloat(0.1f) + 0.45f));
        int rgb = Color.HSBtoRGB(hueShift, saturation, brightnessFactor);
        int alpha = (int)(brightnessFactor * 255.0f);
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public void renderForBone(AzRendererPipelineContext azRendererPipelineContext, AzBone azBone) {
    }
}

