/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3486;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindWaterTask
extends JSTaskBase {
    private class_243 targetPos;
    private class_243 targetWater;
    private int drinkingTicks;
    private int ticks;
    private int lastSearchTick = -9999;
    private int checkCooldown;
    private boolean pathStarted;
    private boolean scanning;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPaths = new AtomicInteger();
    private final List<Candidate> candidates = new ArrayList<Candidate>(32);
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 24;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int SCAN_STEP = 5;
    private static final int MAX_LAST_DRANK_DIST = 512;
    private static final int SLICE_SIZE = 64;
    private boolean requiresShore = false;
    private int range = 64;

    public JSFindWaterTask(JSAnimalBase animal) {
        super(animal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public JSFindWaterTask noShore() {
        this.requiresShore = false;
        return this;
    }

    public JSFindWaterTask setRange(int range) {
        this.range = range;
        return this;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        float thirst = (float)this.animal.getModules().getMetabolismModule().thirstPercentage();
        if ((double)thirst > 0.8) {
            return TaskPriority.LOW;
        }
        if ((double)thirst > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if ((double)thirst > 0.4) {
            return TaskPriority.HIGH;
        }
        if ((double)thirst > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.checkCooldown < 0) {
            this.checkCooldown = 0;
        }
        if (this.checkCooldown-- != 0 || this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isThirstEnabled()) {
            return false;
        }
        if (this.animal.lastDrankAtPos != null && this.animal.lastDrankAtPos.method_10262((class_2382)this.animal.method_24515()) > 262144.0) {
            this.animal.lastDrankAtPos = null;
        }
        if (this.ticks - this.lastSearchTick >= 20 && !this.scanning && this.candidates.isEmpty()) {
            class_2338 center = this.animal.method_24515();
            this.lastSearchTick = this.ticks;
            this.scanning = true;
            CompletableFuture.runAsync(() -> {
                try {
                    this.collectCandidates(center, this.range);
                }
                finally {
                    this.scanning = false;
                }
            });
        }
        if (this.targetPos != null && this.targetWater != null) {
            return true;
        }
        if (!this.candidates.isEmpty()) {
            this.requestPaths();
        }
        ++this.ticks;
        return this.scanning || this.targetPos != null && this.targetWater != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirstEnabled()) {
            return false;
        }
        return this.scanning || this.pendingPaths.get() > 0 || !this.candidates.isEmpty() || this.targetPos != null && this.targetWater != null;
    }

    public boolean canInterrupt() {
        return this.targetPos == null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.animal.method_19540(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.scanning) {
            return;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        ++this.drinkingTicks;
        if (this.drinkingTicks > 200 && this.animal.getNavigationController().isDone() && this.animal.getNavigationController().isStuck()) {
            this.stop();
            this.checkCooldown = 5;
            return;
        }
        if (this.reachedWater()) {
            this.drink();
            return;
        }
        if (this.targetPos == null && !this.candidates.isEmpty()) {
            Candidate next = this.candidates.remove(0);
            this.targetPos = class_243.method_24953((class_2382)next.land);
            this.targetWater = class_243.method_24953((class_2382)next.water);
            this.pathStarted = false;
        }
        if (this.targetPos != null && (!this.pathStarted || this.animal.getNavigationController().isDone()) && this.pendingPaths.get() < 4) {
            CompletableFuture future = this.animal.getNavigationController().createPath(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, 1);
            if (future != null) {
                this.pendingPaths.incrementAndGet();
                future.thenAccept(path -> {
                    try {
                        if (path != null) {
                            this.animal.getNavigationController().moveTo(path);
                            this.pathStarted = true;
                        } else {
                            this.clearTarget();
                        }
                    }
                    finally {
                        this.pendingPaths.decrementAndGet();
                    }
                });
            } else {
                this.clearTarget();
            }
        }
        ++this.ticks;
    }

    public void onStop() {
        this.animal.method_19540(false);
    }

    public void cleanUp() {
        this.clearAll();
    }

    private void drink() {
        this.animal.getNavigationController().stop();
        if (this.targetWater != null) {
            this.animal.method_5702(class_2183.class_2184.field_9853, this.targetWater);
        }
        this.animal.getModules().getMetabolismModule().setThirst(this.animal.getModules().getMetabolismModule().getMaxThirst());
        this.animal.curDrinkTicks = 5;
        if (this.targetWater != null) {
            this.animal.lastDrankAtPos = class_2338.method_49638((class_2374)this.targetWater);
        }
        this.clearTarget();
        this.drinkingTicks = 0;
        this.checkCooldown = 10;
    }

    private boolean reachedWater() {
        return this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 3.0f) || this.animal.method_5799();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCandidates(class_2338 center, int halfRange) {
        class_1937 lvl = this.animal.method_37908();
        class_243 mobPos = this.animal.method_19538();
        List found = Collections.synchronizedList(new ArrayList());
        int minX = center.method_10263() - halfRange;
        int maxX = center.method_10263() + halfRange;
        int minZ = center.method_10260() - halfRange;
        int maxZ = center.method_10260() + halfRange;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int sx = minX; sx <= maxX; sx += 64) {
            int sliceMaxX = Math.min(maxX, sx + 64 - 1);
            for (int sz = minZ; sz <= maxZ; sz += 64) {
                int sliceMaxZ = Math.min(maxZ, sz + 64 - 1);
                int finalSx = sx;
                int finalSz = sz;
                futures.add(CompletableFuture.runAsync(() -> {
                    class_2338.class_2339 check = new class_2338.class_2339();
                    for (int x = finalSx; x <= sliceMaxX; x += 5) {
                        block1: for (int z = finalSz; z <= sliceMaxZ; z += 5) {
                            int surfaceY = lvl.method_8624(class_2902.class_2903.field_13202, x, z);
                            class_2338 pos = new class_2338(x, surfaceY - 1, z);
                            if (!lvl.method_8316(pos).method_15767(class_3486.field_15517) || !lvl.method_8320(pos.method_10084()).method_26215()) continue;
                            if (this.requiresShore) {
                                for (class_2350 dir : class_2350.class_2353.field_11062) {
                                    check.method_25505((class_2382)pos, dir);
                                    if (!lvl.method_8320((class_2338)check).method_26215() || !lvl.method_8320(check.method_10084()).method_26215() || !lvl.method_8320(check.method_10074()).method_26216((class_1922)lvl, check.method_10074())) continue;
                                    found.add(new Candidate(check.method_10062(), pos.method_10062(), mobPos.method_1025(class_243.method_24953((class_2382)check))));
                                    continue block1;
                                }
                                continue;
                            }
                            found.add(new Candidate(pos.method_10062(), pos.method_10062(), mobPos.method_1025(class_243.method_24953((class_2382)pos))));
                        }
                    }
                }));
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        found.sort((a, b) -> {
            double da = a.dist * (1.0 + this.rng.nextDouble() * 0.25);
            double db = b.dist * (1.0 + this.rng.nextDouble() * 0.25);
            return Double.compare(da, db);
        });
        if (found.size() > 24) {
            found.subList(24, found.size()).clear();
        }
        List<Candidate> list = this.candidates;
        synchronized (list) {
            this.candidates.removeIf(this::isInvalid);
            this.candidates.addAll(found);
        }
    }

    private boolean isInvalid(Candidate c) {
        class_1937 lvl = this.animal.method_37908();
        if (!lvl.method_8316(c.water).method_15767(class_3486.field_15517)) {
            return true;
        }
        if (!lvl.method_8320(c.water.method_10084()).method_26215()) {
            return true;
        }
        if (this.requiresShore) {
            if (!lvl.method_8320(c.land).method_26215()) {
                return true;
            }
            if (!lvl.method_8320(c.land.method_10084()).method_26215()) {
                return true;
            }
            return !lvl.method_8320(c.land.method_10074()).method_26216((class_1922)lvl, c.land.method_10074());
        }
        return false;
    }

    private void requestPaths() {
        int reqs = 0;
        for (Candidate c : this.candidates) {
            if (reqs >= 3 || this.pendingPaths.get() >= 4 || this.targetPos != null) break;
            CompletableFuture future = this.animal.getNavigationController().createPath(c.land, 0.0);
            if (future == null) continue;
            this.targetPos = class_243.method_24953((class_2382)c.land);
            this.targetWater = class_243.method_24953((class_2382)c.water);
            this.pathStarted = false;
            this.pendingPaths.incrementAndGet();
            ++reqs;
            future.thenAccept(path -> {
                try {
                    if (path != null) {
                        this.animal.getNavigationController().moveTo(path);
                        this.pathStarted = true;
                    } else {
                        this.clearTarget();
                    }
                }
                finally {
                    this.pendingPaths.decrementAndGet();
                }
            });
        }
    }

    private void clearTarget() {
        this.targetWater = null;
        this.targetPos = null;
        this.pathStarted = false;
    }

    private void clearAll() {
        this.clearTarget();
        this.checkCooldown = 0;
        this.ticks = 0;
        this.drinkingTicks = 0;
        this.pendingPaths.set(0);
        this.pathStarted = false;
        this.scanning = false;
    }

    private record Candidate(class_2338 land, class_2338 water, double dist) {
    }
}

