/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.function.Supplier;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import oshi.util.tuples.Pair;

public class JSMetabolismProperties<T extends JSAnimalBase> {
    private int maxWater = 10000;
    private int maxFood = 10000;
    private int maxStamina = 1000;
    private int breedCooldown = (int)JSUtils.toTicksMCDays(2.0f);
    private int gestationTicks = (int)JSUtils.toTicksMCDays(0.5f);
    private float stalkingSpeedMultiplier = 1.0f;
    private float accelerationSpeedMultiplier = 1.0f;
    private boolean canSleep = true;
    private boolean lifeBirth = false;
    private boolean canBreed = true;
    private boolean hungerEnabled = true;
    private boolean thirstEnabled = true;
    private Supplier<Diet> dietSupplier = Diets.EMPTY;
    private AnimalDietType dietType = AnimalDietType.NONE;
    private ActiveTime activeTime = ActiveTime.DIURNAL;
    private Pair<Integer, Integer> clutchSize = new Pair((Object)1, (Object)1);

    public JSMetabolismProperties<T> setClutchSize(int min, int max) {
        this.clutchSize = new Pair((Object)Math.max(min, 1), (Object)Math.max(max, 1));
        return this;
    }

    public JSMetabolismProperties<T> disableBreeding() {
        this.canBreed = false;
        return this;
    }

    public JSMetabolismProperties<T> enableLifeBirth() {
        this.lifeBirth = true;
        return this;
    }

    public JSMetabolismProperties<T> disableSleep() {
        this.canSleep = false;
        return this;
    }

    public JSMetabolismProperties<T> disableFood() {
        this.hungerEnabled = false;
        return this;
    }

    public JSMetabolismProperties<T> disableWater() {
        this.thirstEnabled = false;
        return this;
    }

    public JSMetabolismProperties<T> setDiet(AnimalDietType mainType, Supplier<Diet> diet) {
        this.dietSupplier = diet;
        this.dietType = mainType;
        return this;
    }

    public int getMaxWater() {
        return this.maxWater;
    }

    public int getMaxFood() {
        return this.maxFood;
    }

    public int getMaxStamina() {
        return this.maxStamina;
    }

    public int getBreedCooldown() {
        return this.breedCooldown;
    }

    public int getGestationTicks() {
        return this.gestationTicks;
    }

    public float getStalkingSpeedMultiplier() {
        return this.stalkingSpeedMultiplier;
    }

    public float getAccelerationSpeedMultiplier() {
        return this.accelerationSpeedMultiplier;
    }

    public boolean isCanSleep() {
        return this.canSleep;
    }

    public boolean isLifeBirth() {
        return this.lifeBirth;
    }

    public boolean isCanBreed() {
        return this.canBreed;
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public boolean isThirstEnabled() {
        return this.thirstEnabled;
    }

    public Supplier<Diet> getDietSupplier() {
        return this.dietSupplier;
    }

    public AnimalDietType getDietType() {
        return this.dietType;
    }

    public ActiveTime getActiveTime() {
        return this.activeTime;
    }

    public Pair<Integer, Integer> getClutchSize() {
        return this.clutchSize;
    }

    public JSMetabolismProperties<T> setMaxWater(int maxWater) {
        this.maxWater = maxWater;
        return this;
    }

    public JSMetabolismProperties<T> setMaxFood(int maxFood) {
        this.maxFood = maxFood;
        return this;
    }

    public JSMetabolismProperties<T> setMaxStamina(int maxStamina) {
        this.maxStamina = maxStamina;
        return this;
    }

    public JSMetabolismProperties<T> setBreedCooldown(int breedCooldown) {
        this.breedCooldown = breedCooldown;
        return this;
    }

    public JSMetabolismProperties<T> setGestationTicks(int gestationTicks) {
        this.gestationTicks = gestationTicks;
        return this;
    }

    public JSMetabolismProperties<T> setStalkingSpeedMultiplier(float stalkingSpeedMultiplier) {
        this.stalkingSpeedMultiplier = stalkingSpeedMultiplier;
        return this;
    }

    public JSMetabolismProperties<T> setAccelerationSpeedMultiplier(float accelerationSpeedMultiplier) {
        this.accelerationSpeedMultiplier = accelerationSpeedMultiplier;
        return this;
    }

    public JSMetabolismProperties<T> setCanSleep(boolean canSleep) {
        this.canSleep = canSleep;
        return this;
    }

    public JSMetabolismProperties<T> setLifeBirth(boolean lifeBirth) {
        this.lifeBirth = lifeBirth;
        return this;
    }

    public JSMetabolismProperties<T> setCanBreed(boolean canBreed) {
        this.canBreed = canBreed;
        return this;
    }

    public JSMetabolismProperties<T> setHungerEnabled(boolean hungerEnabled) {
        this.hungerEnabled = hungerEnabled;
        return this;
    }

    public JSMetabolismProperties<T> setThirstEnabled(boolean thirstEnabled) {
        this.thirstEnabled = thirstEnabled;
        return this;
    }

    public JSMetabolismProperties<T> setDietSupplier(Supplier<Diet> dietSupplier) {
        this.dietSupplier = dietSupplier;
        return this;
    }

    public JSMetabolismProperties<T> setDietType(AnimalDietType dietType) {
        this.dietType = dietType;
        return this;
    }

    public JSMetabolismProperties<T> setActiveTime(ActiveTime activeTime) {
        this.activeTime = activeTime;
        return this;
    }

    public JSMetabolismProperties<T> setClutchSize(Pair<Integer, Integer> clutchSize) {
        this.clutchSize = clutchSize;
        return this;
    }
}

