/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.egg;

import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;
import travelers.server.animal.ModelType;

public class EggEntity
extends class_1308 {
    private static final class_2940<Integer> hatchTicks = class_2945.method_12791(EggEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> hatched = class_2945.method_12791(EggEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_2487> gene_data = class_2945.method_12791(EggEntity.class, (class_2941)class_2943.field_13318);
    private static final int DECAY_TICKS = 2000;
    private int maxTicks;
    private int decayTicks;
    private JSAnimal<?> animal = null;
    private JSGeneData data = new JSGeneData();
    private class_4048 dimensions = null;

    public EggEntity(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createLivingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0);
    }

    public void method_5773() {
        super.method_5773();
        if (!((Boolean)this.field_6011.method_12789(hatched)).booleanValue()) {
            JSAnimations.IDLE.sendForEntity(ModelType.AZURE, (class_1297)this);
            if (this.animal != null) {
                int maxTicks = this.getMaxHatchTicks();
                int ticks = this.getHatchTicks();
                if (++ticks >= maxTicks) {
                    this.hatch();
                    this.setHatchTicks(ticks);
                    return;
                }
                this.setHatchTicks(ticks);
            }
        } else {
            JSAnimations.OPEN_HOLD.sendForEntity(ModelType.AZURE, (class_1297)this);
            if (this.decayTicks < 2000) {
                ++this.decayTicks;
            } else {
                this.method_5768();
            }
        }
    }

    private void hatch() {
        JSAnimalBase base = (JSAnimalBase)((class_1299)this.animal.getEntityType().get()).method_5883(this.method_37908());
        if (base == null) {
            return;
        }
        base.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        base.method_45166(this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            base.method_5943((class_5425)level, level.method_8404(this.method_24515()), class_3730.field_16465, null);
            base.getModules().getMetabolismModule().setMax();
            base.getModules().getGeneticModule().setGeneData(this.data);
            level.method_8649((class_1297)base);
            this.field_6011.method_12778(hatched, (Object)true);
        }
    }

    @NotNull
    public class_3619 method_5657() {
        return class_3619.field_15971;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(hatchTicks, (Object)0);
        builder.method_56912(hatched, (Object)false);
        builder.method_56912(gene_data, (Object)new class_2487());
        super.method_5693(builder);
    }

    public void method_5749(class_2487 compound) {
        this.setHatchTicks(compound.method_10550("js.hatch_ticks"));
        this.setMaxHatchTicks(compound.method_10550("js.max_hatch_ticks"));
        this.decayTicks = compound.method_10550("js.decay");
        this.field_6011.method_12778(hatched, (Object)compound.method_10577("js.hatched"));
        class_2487 tag = compound.method_10562("js.animal");
        this.data.loadFromNbt(tag);
        this.field_6011.method_12778(gene_data, (Object)tag);
    }

    public void method_5652(class_2487 compound) {
        compound.method_10569("js.hatch_ticks", this.getHatchTicks());
        compound.method_10569("js.max_hatch_ticks", this.getMaxHatchTicks());
        compound.method_10569("js.decay", this.decayTicks);
        compound.method_10556("js.hatched", ((Boolean)this.field_6011.method_12789(hatched)).booleanValue());
        class_2487 tag = new class_2487();
        this.data.saveToNbt(tag);
        compound.method_10566("js.animal", (class_2520)tag);
    }

    private int getHatchTicks() {
        return (Integer)this.field_6011.method_12789(hatchTicks);
    }

    private void setHatchTicks(int anInt) {
        this.field_6011.method_12778(hatchTicks, (Object)anInt);
    }

    private int getMaxHatchTicks() {
        return this.maxTicks;
    }

    public void setMaxHatchTicks(int maxHatchTicks) {
        this.maxTicks = maxHatchTicks;
    }

    public float getSize() {
        if (this.animal == null) {
            this.animal = this.getAnimal();
        }
        if (this.animal != null) {
            return (float)this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale();
        }
        return 1.0f;
    }

    @NotNull
    protected class_238 method_33332() {
        if (this.data == null) {
            return this.method_55694(this.method_18376()).method_30757(this.method_19538());
        }
        JSAnimal<?> animal1 = this.getAnimal();
        if (animal1 == null) {
            return this.method_55694(this.method_18376()).method_30757(this.method_19538());
        }
        if (this.dimensions == null) {
            if (this.animal != null) {
                float xz = (float)((double)0.325f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                float y = (float)((double)0.525f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                this.dimensions = class_4048.method_18384((float)xz, (float)y);
            } else {
                return this.method_55694(this.method_18376()).method_30757(this.method_19538());
            }
        }
        return this.dimensions.method_30757(this.method_19538());
    }

    private JSAnimal<?> getAnimal() {
        return JSAnimals.getAnimal(this.data.getDataOwnerName());
    }

    public void method_5982() {
        if (((Boolean)this.field_6011.method_12789(hatched)).booleanValue()) {
            super.method_5982();
        }
    }

    protected void method_6108() {
        this.method_37908().method_8421((class_1297)this, (byte)60);
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public void method_48922(class_1282 damageSource) {
        if (damageSource.method_49708(class_8111.field_42320)) {
            super.method_48922(damageSource);
        }
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        if (damageSource.method_49708(class_8111.field_42320) || damageSource.method_49708(class_8111.field_44869) && ((Boolean)this.field_6011.method_12789(hatched)).booleanValue()) {
            super.method_6074(damageSource, damageAmount);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42320) || source.method_49708(class_8111.field_44869) && ((Boolean)this.field_6011.method_12789(hatched)).booleanValue()) {
            return super.method_5643(source, amount);
        }
        return false;
    }

    public void setData(JSGeneData data) {
        this.field_6011.method_12778(gene_data, (Object)data.saveToNbt(new class_2487()));
        this.data = data;
        this.animal = data.getAnimal();
        if (!TravelersMain.isDebugging()) {
            this.setMaxHatchTicks(this.animal.getAnimalAttributes().getGeneticProperties().getEggHatchTicks());
        } else {
            this.setMaxHatchTicks(5);
        }
    }
}

