/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_5894;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.client.TravelersClient;

public class GenderSpawnEgg
extends class_1826
implements AnimalAttachment {
    private static final List<GenderSpawnEgg> MOD_EGGS = new ArrayList<GenderSpawnEgg>();
    private static final class_2357 DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        class_2350 face = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_1299 type = ((class_1826)stack.method_7909()).method_8015(stack);
        try {
            class_1297 base = type.method_5883((class_1937)source.comp_1967());
            if (base instanceof JSAnimalBase) {
                JSAnimalBase entity = (JSAnimalBase)base;
                class_1792 patt0$temp = stack.method_7909();
                if (patt0$temp instanceof GenderSpawnEgg) {
                    GenderSpawnEgg spawnEgg = (GenderSpawnEgg)patt0$temp;
                    Object id = stack.method_57824((class_9331)JSDataComponents.SPAWN_TYPE.get());
                    int integer = SpawnEggMode.BOTH.id;
                    if (id != null) {
                        if (id instanceof Integer) {
                            Integer integer1 = (Integer)id;
                            integer = integer1;
                        }
                    } else {
                        stack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
                    }
                    SpawnEggMode mode = SpawnEggMode.getMode(integer);
                    if (mode != SpawnEggMode.BOTH) {
                        entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
                    } else {
                        entity.getModules().getGeneticModule().setMale(entity.method_59922().method_43056());
                    }
                    entity.getModules().getGrowthStageModule().setMax();
                    entity.getModules().getMetabolismModule().setMax();
                    JSGeneData data = JSGeneUtil.readFromStack(stack);
                    data.setDataOwnerName(spawnEgg.animal.getAnimalAttributes().getModId() + ":" + spawnEgg.animal.getAnimalAttributes().getAnimalName());
                    entity.getModules().getGeneticModule().setGeneData(data);
                    entity.getModules().getGeneticModule().hatch();
                    stack.method_7934(1);
                    entity.method_33574(source.comp_1968().method_10093(face).method_61082());
                    source.comp_1967().method_8649((class_1297)entity);
                    source.comp_1967().method_43276((class_6880)class_5712.field_28738, source.comp_1968(), class_5712.class_7397.method_43287((class_2680)source.comp_1969()));
                }
            }
        }
        catch (Exception exception) {
            class_2357.field_34020.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.comp_1968(), (Object)exception);
            return class_1799.field_8037;
        }
        return stack;
    };
    private final Supplier<? extends class_1299<? extends JSAnimalBase>> typeSupplier;
    public final int backGroundColorMale;
    public final int highlightColorMale;
    public final int backgroundColorFemale;
    public final int highlightColorFemale;
    private final JSAnimal<?> animal;

    public GenderSpawnEgg(JSAnimal<?> animal, Supplier<? extends class_1299<? extends JSAnimalBase>> type, int backgroundColor, int highlightColor, int backGroundColorMale, int highlightColorMale, class_1792.class_1793 props) {
        super(type.get(), backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        this.backgroundColorFemale = backgroundColor;
        this.highlightColorFemale = highlightColor;
        this.backGroundColorMale = backGroundColorMale;
        this.highlightColorMale = highlightColorMale;
        this.animal = animal;
        MOD_EGGS.add(this);
    }

    public static SpawnEggMode getSpawnEggMode(Object id) {
        SpawnEggMode curMode;
        int integer = SpawnEggMode.BOTH.id;
        if (id != null && id instanceof Integer) {
            Integer integer1 = (Integer)id;
            integer = integer1;
        }
        SpawnEggMode mode = curMode = SpawnEggMode.getMode(integer);
        if (curMode == SpawnEggMode.BOTH) {
            mode = TravelersClient.clientTicks % 64 > 32 ? SpawnEggMode.MALE : SpawnEggMode.FEMALE;
        }
        return mode;
    }

    private static void showTitle(class_3222 serverPlayer, SpawnEggMode mode) {
        class_5250 textComponent = class_2561.method_43471((String)mode.getTranslationKey()).method_27692(class_124.field_1065);
        class_5894 actionBarPacket = new class_5894((class_2561)textComponent);
        serverPlayer.field_13987.method_14364((class_2596)actionBarPacket);
    }

    public static void registerDispense() {
        for (GenderSpawnEgg modEgg : MOD_EGGS) {
            class_2357 dispenseBehavior = modEgg.createDispenseBehavior();
            if (dispenseBehavior == null) continue;
            class_2315.method_10009((class_1935)modEgg, (class_2357)dispenseBehavior);
        }
    }

    @NotNull
    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        stack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
        JSGeneData genes = this.animal.getAnimalAttributes().getGeneticProperties().getSpawnGenetics();
        genes.setBaseQuality(100);
        return JSGeneUtil.writeToStack(stack, genes);
    }

    @NotNull
    public class_1799 getDefaultInstanceNoData() {
        class_1799 stack = super.method_7854();
        stack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
        return stack;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.version").method_27693(String.valueOf(this.animal.getAnimalAttributes().getMiscProperties().getVersion())).method_27692(class_124.field_1063));
        if (stack.method_7960()) {
            return;
        }
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.geneDataHolder.getGENE_SET().isEmpty()) {
            return;
        }
        if (!JSCommon.isShiftKeyDown && !tooltipFlag.method_8035()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.shift_hint").method_27692(class_124.field_1078));
        } else if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Genes:"));
            int geneId = 0;
            for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(++geneId + ". ")).method_10852((class_2561)gene.getTranslatableObject()).method_27692(gene.getToolTipColour()));
            }
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        if (!(level instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_1799 itemstack = pContext.method_8041();
        class_2338 blockpos = pContext.method_8037();
        class_2350 direction = pContext.method_8038();
        class_2680 blockstate = level.method_8320(blockpos);
        class_1657 player = pContext.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_2338 blockpos1 = blockstate.method_26220((class_1922)level, blockpos).method_1110() ? blockpos : blockpos.method_10093(direction);
        class_1299 entitytype = this.method_8015(itemstack);
        JSAnimalBase entity = (JSAnimalBase)entitytype.method_5883(level);
        if (entity != null) {
            Object id = itemstack.method_57824((class_9331)JSDataComponents.SPAWN_TYPE.get());
            int integer = SpawnEggMode.BOTH.id;
            if (id != null) {
                if (id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
            } else {
                itemstack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.method_59922().method_43056());
            }
            if (player.method_5715()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.method_33574(blockpos1.method_61082());
            level.method_8649((class_1297)entity);
            itemstack.method_7934(1);
            level.method_33596((class_1297)pContext.method_8036(), (class_6880)class_5712.field_28738, blockpos);
        }
        return class_1269.field_21466;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 pLevel, class_1657 pPlayer, @NotNull class_1268 pHand) {
        class_1799 itemstack = pPlayer.method_5998(pHand);
        class_3965 blockhitresult = GenderSpawnEgg.method_7872((class_1937)pLevel, (class_1657)pPlayer, (class_3959.class_242)class_3959.class_242.field_1345);
        if (pPlayer.method_5715() && blockhitresult.method_17783() != class_239.class_240.field_1332) {
            if (!pLevel.method_8608()) {
                Object id = itemstack.method_57824((class_9331)JSDataComponents.SPAWN_TYPE.get());
                int integer = SpawnEggMode.BOTH.id;
                if (id != null && id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
                SpawnEggMode mode = SpawnEggMode.getMode(integer);
                itemstack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.nextMode((SpawnEggMode)mode).id);
                if (pPlayer instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)pPlayer;
                    GenderSpawnEgg.showTitle(serverPlayer, SpawnEggMode.nextMode(mode));
                }
            }
            return class_1271.method_22430((Object)itemstack);
        }
        if (blockhitresult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemstack);
        }
        if (!(pLevel instanceof class_3218)) {
            return class_1271.method_22427((Object)itemstack);
        }
        class_2338 blockpos = blockhitresult.method_17777();
        if (!(pLevel.method_8320(blockpos).method_26204() instanceof class_2404)) {
            return class_1271.method_22430((Object)itemstack);
        }
        if (pLevel.method_8505(pPlayer, blockpos) && pPlayer.method_7343(blockpos, blockhitresult.method_17780(), itemstack)) {
            class_1299 entitytype = this.method_8015(itemstack);
            JSAnimalBase entity = (JSAnimalBase)entitytype.method_5883(pLevel);
            if (entity == null) {
                return class_1271.method_22430((Object)itemstack);
            }
            Object id = itemstack.method_57824((class_9331)JSDataComponents.SPAWN_TYPE.get());
            int integer = SpawnEggMode.BOTH.id;
            if (id != null) {
                if (id instanceof Integer) {
                    Integer integer1 = (Integer)id;
                    integer = integer1;
                }
            } else {
                itemstack.method_57379((class_9331)JSDataComponents.SPAWN_TYPE.get(), (Object)SpawnEggMode.BOTH.id);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.method_59922().method_43056());
            }
            if (pPlayer.method_5715()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            itemstack.method_57008(1, (class_1309)pPlayer);
            entity.method_33574(blockpos.method_61082());
            pLevel.method_8649((class_1297)entity);
            pPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
            pLevel.method_43275((class_1297)pPlayer, (class_6880)class_5712.field_28738, entity.method_19538());
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22431((Object)itemstack);
    }

    @Nullable
    protected class_2357 createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Override
    public JSAnimal<?> getAnimal() {
        return this.animal;
    }

    public static List<GenderSpawnEgg> getMOD_EGGS() {
        return MOD_EGGS;
    }

    public static enum SpawnEggMode {
        BOTH(0, "tooltip.jurassicsaga.genderspawnegg.both"),
        MALE(1, "tooltip.jurassicsaga.genderspawnegg.male"),
        FEMALE(2, "tooltip.jurassicsaga.genderspawnegg.female");

        private static final Random random;
        private final int id;
        private final String translationKey;

        private SpawnEggMode(int id, String translationKey) {
            this.id = id;
            this.translationKey = translationKey;
        }

        public static SpawnEggMode nextMode(SpawnEggMode currentMode) {
            switch (currentMode.ordinal()) {
                case 1: {
                    return FEMALE;
                }
                case 0: {
                    return MALE;
                }
            }
            return BOTH;
        }

        public static SpawnEggMode getMode(int mode) {
            for (SpawnEggMode value : SpawnEggMode.values()) {
                if (value.id != mode) continue;
                return value;
            }
            return BOTH;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        static {
            random = new Random();
        }
    }
}

