/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import java.util.Locale;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.MosquitoAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class MosquitoAnimal
extends AbstractJSAnimal<MosquitoEntity> {
    public MosquitoAnimal() {
        super("mosquito");
        this.setAnimator(new MosquitoAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MosquitoEntity> geneticProperties) {
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MosquitoEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MosquitoEntity> miscProperties) {
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MosquitoEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class);
        socialGroupProperties.addHerdTargets(MosquitoEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(50.0f);
        socialGroupProperties.setMaxHerdSize(20);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MosquitoEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableProxyEgg();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(9267005, 5643534);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MosquitoEntity> attributes, EntityBaseProperties<MosquitoEntity> base) {
        base.setAnimalType(AnimalType.INSECT);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(64.0);
        base.setMaxHeadRotation(90.0, 30.0);
        base.setRenderScale((double)0.15f);
        base.setLocator((ResourceLocator)new ResourceLocator<MosquitoEntity>(this){

            public class_2960 getModelLocation(MosquitoEntity entity) {
                String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                return JSCommon.createId("geo/animal/" + entity_name + "/" + entity_name + ".geo.json");
            }

            public class_2960 getAnimationLocation(MosquitoEntity entity) {
                String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                return JSCommon.createId("animations/animal/" + entity_name + "/" + entity_name + ".animation.json");
            }

            public class_2960 getTextureLocation(MosquitoEntity entity) {
                String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                return JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + ".png");
            }
        });
        attributes.setSpawnFar();
        attributes.setEntityFactory(MosquitoEntity::new);
        attributes.setCategory(class_1311.field_6303);
        attributes.setEyeHeight(0.5);
        attributes.setMaxHealth(0.5);
        attributes.setAttackDamage(0.0);
        attributes.setAttackSpeed(3.0);
        attributes.setDimensions(0.5, 0.5);
        attributes.setMovementSpeed((double)0.04f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.15f);
    }
}

