/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.avian.MeganeuraAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.MeganeuraEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1802;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class MeganeuraAnimal
extends AbstractJSAnimal<MeganeuraEntity> {
    public MeganeuraAnimal() {
        super("meganeura");
        this.setAnimator(new MeganeuraAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MeganeuraEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.1f);
        geneticProperties.addGrowthNextStageScaling(0.5f);
        geneticProperties.addGrowthStageSize(0.5f, 0.4f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(4.9f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(5.0f));
        geneticProperties.addSupportedGenes(JSGenetics.ARID_COSMETIC, JSGenetics.RAINFOREST_COSMETIC, JSGenetics.RIVER_COSMETIC, JSGenetics.TAIGA_COSMETIC, JSGenetics.TROPICAL_COSMETIC, JSGenetics.TUNDRA_COSMETIC, JSGenetics.VIVID_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MeganeuraEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.INSECTOVORE, () -> Diets.INSECTOVORE.get().addItem(class_1802.field_8726));
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MeganeuraEntity> miscProperties) {
        miscProperties.setGuidebookScaling(new float[]{3.0f, 3.0f});
        miscProperties.setGuidebookOffset(new class_241(-0.45f, 0.0f), new class_241(0.0f, 0.0f));
        miscProperties.setCorpseMeatDrops(1, 1);
        miscProperties.setCorpseDropTimes(1);
        miscProperties.setCorpseBoneDrops(0, 1);
        miscProperties.setEra(Era.CARBONIFEROUS);
        miscProperties.setMaxTurnRate(32.0f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("A giant predatory insect from the Carboniferous period with a wingspan of up to 70 cm. It resembled a modern dragonfly but lived in a high-oxygen atmosphere that allowed insects to grow much larger than today.");
        miscProperties.setGuideBookSource("North America, Europe");
        miscProperties.setGuideBookScientificName("Meganeura monyi");
        miscProperties.setAdvancementTitle("Look At The Size Of It");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MeganeuraEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.addHuntTargets(MosquitoEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(0.0f);
        socialGroupProperties.setMinDistanceToPackLeader(0.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MeganeuraEntity> itemProperties) {
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(4489728, 1147004);
        itemProperties.setSampleColour(SampleColour.INSECT);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MeganeuraEntity> attributes, EntityBaseProperties<MeganeuraEntity> base) {
        base.setAnimalType(AnimalType.INSECT);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setFov(90.0);
        base.setRenderScale((double)0.3f);
        base.setLocator(new JSAnimalBaseLocator(false));
        base.setBabyAnimations();
        base.setSpecialRenderer();
        attributes.setPersistent();
        attributes.setEntityFactory(MeganeuraEntity::new);
        attributes.setEyeHeight((double)0.8f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(15.0);
        attributes.setDimensions(1.0, (double)0.4f);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.185f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(32.0);
        attributes.setTrackingRange(32.0);
    }
}

