/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSDiveBombTask
extends JSTaskBase {
    private static final double MIN_RADIUS = 15.0;
    private static final double MAX_RADIUS = 20.0;
    private static final double MIN_ALT = 12.0;
    private static final double MAX_ALT = 18.0;
    private static final double CIRCLE_SPEED = 0.06;
    private static final double DIVE_ACCEL = 0.2;
    private static final double DIVE_SPEED_BASE = 1.5;
    private static final double HIT_RANGE_SQR = 12.25;
    private static final int DIVE_COOLDOWN_TICKS = 80;
    private static final double ORBIT_STEER = 0.05;
    private static final double RECOVER_STEER = 0.07;
    private static final double CLIMB_FACTOR = 0.0015;
    private static final double MAX_HORIZ_SPEED = 0.6;
    private static final int TIMEOUT_TICKS = 600;
    private long stuckTick;
    private Phase phase;
    private final JSAvianBase pterodactyl;
    private class_1309 target;
    private double angle;
    private double radius;
    private double alt;
    private long lastDiveTick;

    public JSDiveBombTask(JSAvianBase baseAnimal) {
        super(baseAnimal);
        this.pterodactyl = baseAnimal;
        this.getGoals().add(TaskGoal.ATTACK);
        this.setPriority(TaskPriority.VERY_HIGH);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        if (this.pterodactyl.isDead()) {
            return false;
        }
        class_1309 target = this.pterodactyl.method_5968();
        if (this.pterodactyl.method_6113() || this.pterodactyl.isResting()) {
            return false;
        }
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (target instanceof IJSEdibleEntity) {
            return false;
        }
        if (!this.pterodactyl.isFlying()) {
            return false;
        }
        this.target = target;
        return true;
    }

    public void onStart() {
        this.angle = this.random.nextDouble() * Math.PI * 2.0;
        this.radius = 15.0 + this.random.nextDouble() * 5.0;
        this.alt = 12.0 + this.random.nextDouble() * 6.0;
        this.phase = Phase.CIRCLE;
        this.stuckTick = this.pterodactyl.field_6012;
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(true);
        this.pterodactyl.getFlyingPathNavigation().stop();
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        if (this.target == null || !this.target.method_5805() || this.animal.isDead()) {
            this.stop();
            return;
        }
        if (!this.pterodactyl.isFlying()) {
            this.pterodactyl.setFlying(true);
        }
        if (this.pterodactyl.method_18798().method_1027() > 0.001) {
            this.stuckTick = this.pterodactyl.field_6012;
        }
        if (this.phase != Phase.CHASE && (long)this.pterodactyl.field_6012 - this.stuckTick > 600L) {
            this.phase = Phase.CHASE;
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.tickCircle();
                break;
            }
            case 1: {
                this.tickDive();
                break;
            }
            case 2: {
                this.tickRecover();
                break;
            }
            case 3: {
                this.tickChase();
            }
        }
    }

    private void tickCircle() {
        boolean cooldown;
        double dz;
        double dy;
        double cx = this.target.method_23317();
        double cy = this.target.method_23318();
        double cz = this.target.method_23321();
        double orbitY = cy + this.alt;
        this.angle += 0.06;
        double tx = cx + this.radius * Math.cos(this.angle);
        double tz = cz + this.radius * Math.sin(this.angle);
        double dx = tx - this.pterodactyl.method_23317();
        double len = Math.sqrt(dx * dx + (dy = orbitY - this.pterodactyl.method_23318()) * dy + (dz = tz - this.pterodactyl.method_23321()) * dz);
        if (len < 1.0E-4) {
            return;
        }
        class_243 vel = this.pterodactyl.method_18798().method_1021(0.85);
        vel = vel.method_1031((dx /= len) * 0.05, (dy /= len) * 0.05, (dz /= len) * 0.05);
        double climb = (orbitY - this.pterodactyl.method_23318()) * 0.0015;
        vel = vel.method_1031(0.0, climb, 0.0);
        vel = this.clampHorizontalSpeed(vel);
        this.pterodactyl.method_18799(vel);
        this.rotateToVelocity(vel);
        boolean above = this.pterodactyl.method_23318() > cy + 3.5;
        boolean closeHoriz = this.pterodactyl.method_19538().method_1028(cx, this.pterodactyl.method_23318(), cz) <= this.radius * this.radius * 1.2;
        boolean bl = cooldown = (long)this.pterodactyl.field_6012 - this.lastDiveTick >= 80L;
        if (above && closeHoriz && cooldown && this.random.nextInt(35) == 0 && this.pterodactyl.method_6057((class_1297)this.target)) {
            this.phase = Phase.DIVE;
            this.lastDiveTick = this.pterodactyl.field_6012;
            this.radius = 15.0 + this.random.nextDouble() * 5.0;
        }
    }

    private void tickDive() {
        boolean low;
        this.pterodactyl.setDiving(true);
        class_243 tv = this.target.method_18798();
        double leadTicks = 4.0;
        double tx = this.target.method_23317() + tv.field_1352 * leadTicks;
        double ty = this.target.method_23318() + Math.min(0.5, tv.field_1351 * leadTicks);
        double tz = this.target.method_23321() + tv.field_1350 * leadTicks;
        double dx = tx - this.pterodactyl.method_23317();
        double dy = ty - this.pterodactyl.method_23318();
        double dz = tz - this.pterodactyl.method_23321();
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len > 1.0E-5) {
            class_243 vel = this.pterodactyl.method_18798();
            double speed = 1.5 + this.random.nextDouble() * 0.4;
            vel = new class_243(vel.field_1352 * 0.8 + (dx /= len) * (0.2 * speed), vel.field_1351 * 0.8 + (dy /= len) * (0.2 * speed), vel.field_1350 * 0.8 + (dz /= len) * (0.2 * speed));
            this.pterodactyl.method_18799(vel);
            this.rotateToVelocity(vel);
        }
        boolean hitRange = this.pterodactyl.method_5858((class_1297)this.target) <= 12.25;
        boolean passed = this.pterodactyl.method_23318() <= this.target.method_23318() + 0.2;
        boolean bl = low = this.pterodactyl.method_23318() <= (double)(this.level.method_31607() + 2);
        if (hitRange) {
            this.pterodactyl.method_6121((class_1297)this.target);
        }
        if (hitRange || passed || low || !this.pterodactyl.method_6057((class_1297)this.target)) {
            this.phase = Phase.RECOVER;
        }
    }

    private void tickRecover() {
        double dz;
        double dy;
        double cx = this.target.method_23317();
        double cy = this.target.method_23318();
        double cz = this.target.method_23321();
        this.pterodactyl.setDiving(false);
        if (this.random.nextInt(40) == 0) {
            this.radius = 15.0 + this.random.nextDouble() * 5.0;
            this.alt = 12.0 + this.random.nextDouble() * 6.0;
        }
        this.angle += 0.06;
        double targetY = cy + this.alt;
        double tx = cx + this.radius * Math.cos(this.angle);
        double tz = cz + this.radius * Math.sin(this.angle);
        double dx = tx - this.pterodactyl.method_23317();
        double len = Math.sqrt(dx * dx + (dy = targetY - this.pterodactyl.method_23318()) * dy + (dz = tz - this.pterodactyl.method_23321()) * dz);
        if (len < 1.0E-4) {
            return;
        }
        class_243 vel = this.pterodactyl.method_18798().method_1021(0.85);
        vel = vel.method_1031((dx /= len) * 0.07, (dy /= len) * 0.07, (dz /= len) * 0.07);
        double climb = (targetY - this.pterodactyl.method_23318()) * 0.0015;
        vel = vel.method_1031(0.0, climb, 0.0);
        vel = this.clampHorizontalSpeed(vel);
        this.pterodactyl.method_18799(vel);
        this.rotateToVelocity(vel);
        if (this.pterodactyl.method_23318() >= targetY - 0.5) {
            this.phase = Phase.CIRCLE;
        }
    }

    private void tickChase() {
        this.pterodactyl.setDiving(false);
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(true);
        this.pterodactyl.getFlyingPathNavigation().moveTo((class_1297)this.target);
        if (this.pterodactyl.method_5858((class_1297)this.target) <= 12.25) {
            this.pterodactyl.method_6121((class_1297)this.target);
        }
    }

    private void rotateToVelocity(class_243 vel) {
        if (vel.method_1027() < 1.0E-6) {
            return;
        }
        float yaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(class_3532.method_15349((double)vel.field_1351, (double)Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)) * 57.29577951308232));
        this.pterodactyl.field_6283 = this.rotLerp(this.pterodactyl.field_6283, yaw, 8.0f);
        this.pterodactyl.method_36456(this.pterodactyl.field_6283);
        this.pterodactyl.method_36457(pitch);
    }

    private class_243 clampHorizontalSpeed(class_243 vel) {
        double horiz = Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350);
        if (horiz > 0.6) {
            double scale = 0.6 / horiz;
            vel = new class_243(vel.field_1352 * scale, vel.field_1351, vel.field_1350 * scale);
        }
        return vel;
    }

    private float rotLerp(float current, float target, float maxChange) {
        float f = class_3532.method_15393((float)(target - current));
        if (f > maxChange) {
            f = maxChange;
        }
        if (f < -maxChange) {
            f = -maxChange;
        }
        return current + f;
    }

    public void onStop() {
        this.pterodactyl.setDiving(false);
        this.phase = Phase.CIRCLE;
        this.pterodactyl.getFlyingPathNavigation().setLookingForPath(false);
    }

    public boolean canContinueRunning() {
        if (this.pterodactyl.method_6113() || this.pterodactyl.isResting()) {
            return false;
        }
        return this.target != null && this.target.method_5805();
    }

    private static enum Phase {
        CIRCLE,
        DIVE,
        RECOVER,
        CHASE;

    }
}

