/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class LeapOutOfWaterTask
extends JSCombatTaskBase {
    private State state = State.DIVE;
    private int timer = 0;
    private int cooldown = 0;

    public LeapOutOfWaterTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public TaskPriority getPriority() {
        if (this.animal.method_5968() != null && !this.animal.method_5968().method_5777(class_3486.field_15517)) {
            return TaskPriority.HIGH;
        }
        return TaskPriority.LOW;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.method_6113() || this.animal.isResting()) {
            return false;
        }
        if (this.cooldown > 0) {
            this.tickCooldown();
            return false;
        }
        if (this.animal.method_5968() != null) {
            boolean eyeInWater = this.animal.method_5968().method_5777(class_3486.field_15517);
            return !eyeInWater;
        }
        return false;
    }

    public void onStart() {
        this.state = State.DIVE;
        this.timer = 0;
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setLookingForPath(true);
    }

    public boolean canContinueRunning() {
        return true;
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        if (this.animal.method_5968() == null) {
            return;
        }
        class_1309 target = this.animal.method_5968();
        class_243 targetPos = target.method_19538();
        double radius = Math.max(1.0, (double)this.animal.method_17681() * 1.5);
        class_243 centerTarget = targetPos.method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 offsetTarget = centerTarget.method_1031((this.animal.method_59922().method_43058() - 0.5) * radius, 3.0, (this.animal.method_59922().method_43058() - 0.5) * radius);
        int depthAbove = this.getWaterDepthAbove();
        int depth = this.getWaterDepth();
        class_243 delta = target.method_19538().method_1020(this.animal.method_19538());
        double distanceTo = delta.method_1033();
        double maxUpward = 2.5;
        double horizontalSpeed = 0.6;
        double gravity = 0.08;
        double maxHeight = maxUpward * maxUpward / (2.0 * gravity);
        double maxReach = horizontalSpeed * Math.sqrt(2.0 * maxHeight / gravity);
        if (delta.field_1351 > maxHeight || Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350) > maxReach) {
            this.stop();
            return;
        }
        if (this.state == State.DIVE && depthAbove >= 6) {
            this.state = State.CHARGE;
            this.timer = 0;
            this.animal.setLeaping(true);
        }
        switch (this.state.ordinal()) {
            case 0: {
                ++this.timer;
                if (depth < 3) {
                    this.stop();
                    return;
                }
                this.animal.method_18800(this.animal.method_18798().field_1352 * 0.8, -0.25, this.animal.method_18798().field_1350 * 0.8);
                this.animal.method_5702(class_2183.class_2184.field_9851, offsetTarget);
                if (this.timer <= 15) break;
                this.state = State.CHARGE;
                this.timer = 0;
                break;
            }
            case 1: {
                ++this.timer;
                class_243 dir = offsetTarget.method_1020(this.animal.method_19538()).method_1029();
                double accel = Math.min(0.15 + (double)this.timer * 0.02, 0.6);
                class_243 vel = this.animal.method_18798().method_1019(dir.method_1021(accel));
                vel = new class_243(vel.field_1352, Math.min(vel.field_1351, maxUpward), vel.field_1350);
                this.animal.method_18799(vel);
                this.animal.method_5702(class_2183.class_2184.field_9851, offsetTarget);
                float targetYaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(class_3532.method_15349((double)vel.field_1351, (double)Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)) * 57.29577951308232));
                this.animal.method_36456(class_3532.method_16439((float)0.2f, (float)this.animal.method_36454(), (float)targetYaw));
                this.animal.method_36457(class_3532.method_16439((float)0.2f, (float)this.animal.method_36455(), (float)targetPitch));
                this.animal.field_6283 = this.animal.method_36454();
                this.animal.field_6241 = this.animal.method_36454();
                if (this.animal.method_5858((class_1297)target) < (double)((this.animal.method_17681() + 2.0f) * (this.animal.method_17681() + 2.0f))) {
                    this.animal.method_6121((class_1297)target);
                    this.stop();
                    return;
                }
                int maxChargeTime = Math.min(30 + depthAbove * 2, 60);
                if (!(vel.field_1351 > 1.2) && this.timer <= maxChargeTime) break;
                this.state = State.LAUNCH;
                break;
            }
            case 2: {
                this.animal.setLeaping(true);
                class_243 vel = this.animal.method_18798();
                float targetYaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(class_3532.method_15349((double)vel.field_1351, (double)Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)) * 57.29577951308232));
                this.animal.method_36456(class_3532.method_16439((float)0.2f, (float)this.animal.method_36454(), (float)targetYaw));
                this.animal.method_36457(class_3532.method_16439((float)0.2f, (float)this.animal.method_36455(), (float)targetPitch));
                this.animal.field_6283 = this.animal.method_36454();
                this.animal.field_6241 = this.animal.method_36454();
                this.animal.method_5702(class_2183.class_2184.field_9851, offsetTarget);
                if (!this.animal.method_5799() && !this.animal.method_24828()) break;
                this.stop();
            }
        }
    }

    private int getWaterDepth() {
        class_2338 pos = this.animal.method_24515();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            class_2338 check = pos.method_10087(i);
            if (this.animal.method_37908().method_8320(check).method_26227().method_15769()) break;
            ++depth;
        }
        return depth;
    }

    private int getWaterDepthAbove() {
        class_2338 pos = this.animal.method_24515();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            class_2338 check = pos.method_10086(i);
            if (this.animal.method_37908().method_8320(check).method_26227().method_15769()) break;
            ++depth;
        }
        return depth;
    }

    public void onStop() {
        this.animal.setLeaping(false);
        this.animal.getNavigationController().setLookingForPath(false);
        this.animal.method_19540(false);
        this.state = State.DIVE;
        this.timer = 0;
        this.cooldown = 1;
    }

    public void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    private static enum State {
        DIVE,
        CHARGE,
        LAUNCH;

    }
}

