/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersFlyingNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersFlyNodeEvaluator;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public class JSFlyingNavigation
extends TravelersFlyingNavigation {
    private final JSAvianBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSFlyingNavigation(JSAvianBase mob, class_1937 level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.method_52535() || !this.mob.method_5765();
    }

    protected class_243 getTempMobPos() {
        return this.mob.method_19538();
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone() && !this.isLookingForPath) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                class_243 vec3 = this.getTempMobPos();
                class_243 vec31 = this.path.getNextEntityPos((class_1297)this.mob);
                if (vec31.method_1025(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            if (!this.isDone() && !this.isLookingForPath) {
                if (this.path == null) {
                    return;
                }
                class_243 target = this.path.getNextEntityPos((class_1297)this.mob);
                if (this.mob.method_19538().method_24802((class_2374)target, (double)this.maxDistanceToWaypoint)) {
                    if (this.path.isDone()) {
                        this.stop();
                    }
                } else {
                    this.mob.getMoveController().setWantedPosition(target.field_1352, target.field_1351, target.field_1350, 1.0);
                }
            }
        }
    }

    void sendPathFinding(class_1937 level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (TravelersMain.isDebugging()) {
            if (path == null || level.field_9236) {
                return;
            }
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)mob, (class_8710)new TravelersPathFindingDebug(mob.method_5628(), path, maxDistanceToWaypoint));
        }
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        } else {
            this.checkStuckOnNode();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
        if (this.path != null && this.path.isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex < 0 || nodeIndex >= this.path.getNodeCount()) {
            return;
        }
        if (this.curNodeIndex == nodeIndex) {
            ++this.nodeStuckTime;
            if (this.nodeStuckTime > 50) {
                this.recomputePath();
            }
            return;
        }
        this.nodeStuckTime = 0;
        this.curNodeIndex = nodeIndex;
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAvianBase mob, class_243 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 vec31 = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_243 pos = mob.method_19538();
        return vec31.method_55230(pos, (double)Math.max(1.0f, mob.method_17681() / 2.0f), (double)Math.max(1.0f, mob.method_17682() * 2.0f));
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersFlyNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

