/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;
    private boolean shouldObserve = false;
    private int observeTicks = 0;
    private int maxObserveTicks = 40;
    private State state = State.AGGRESSIVE;
    private static final double RUN_AFTER_SPEED = 1.35;
    private static final double RUN_AWAY_DIST = 10.0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    public JSCombatFollowTask observe() {
        this.shouldObserve = true;
        return this;
    }

    @Override
    public boolean shouldRun() {
        class_1309 leaderTarget;
        class_1657 player;
        class_1309 class_13092;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (this.animal.method_5968() != null && (class_13092 = this.animal.method_5968()) instanceof class_1657 && (player = (class_1657)class_13092).method_7337()) {
            this.animal.method_5980(null);
            return false;
        }
        JSHerdModule herdModule = this.animal.getModules().getHerdModule();
        if (herdModule.isFollower() && (leaderTarget = herdModule.getHerdLeader().method_5968()) != null && leaderTarget.method_5805()) {
            return true;
        }
        return this.animal.method_5968() != null && this.animal.method_5968().method_5805();
    }

    @Override
    public void onStart() {
        class_1309 target;
        class_1309 leaderTarget;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().method_5968()) != null && leaderTarget.method_5805()) {
            this.animal.method_5980(leaderTarget);
        }
        if ((target = this.animal.method_5968()) == null || !target.method_5805()) {
            return;
        }
        if (this.callOut && this.random.nextDouble() < 0.875 && herdModule.getFollowers().isEmpty()) {
            this.state = State.CALLING;
            this.callingTicks = this.maxCallingTicks;
        } else if (this.shouldObserve) {
            this.state = State.OBSERVING;
            this.observeTicks = this.maxObserveTicks;
            this.animal.setObserving(true);
        } else {
            this.state = State.AGGRESSIVE;
        }
        this.recomputePathTicks = 0;
    }

    @Override
    public void tick() {
        class_1309 target;
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(400);
        }
        if ((target = this.animal.method_5968()) == null || !target.method_5805()) {
            this.stop();
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.animal.method_19540(false);
                if (this.callingTicks > 0) {
                    --this.callingTicks;
                    this.animal.method_55695();
                    if (!(this.random.nextDouble() < (double)0.05f)) break;
                    this.animal.callSounds();
                    break;
                }
                State state = this.state = this.shouldObserve ? State.OBSERVING : State.AGGRESSIVE;
                if (this.state != State.OBSERVING) break;
                this.observeTicks = this.maxObserveTicks;
                this.animal.setObserving(true);
                break;
            }
            case 1: {
                this.animal.method_19540(false);
                if (this.observeTicks > 0 && !this.extraCheckBeforeSwitch(target, this.animal)) {
                    --this.observeTicks;
                    this.animal.method_55695();
                    this.animal.method_5988().method_19615(target.method_19538());
                    break;
                }
                this.animal.setObserving(false);
                if (this.extraCheckBeforeSwitch(target, this.animal)) {
                    if (!this.canTargetSeeMe(target, (class_1314)this.animal) && this.shouldStalk) {
                        this.state = State.STALKING;
                        this.animal.setStalking(true);
                        break;
                    }
                    this.state = State.AGGRESSIVE;
                    this.animal.method_19540(true);
                    break;
                }
                this.stop();
                return;
            }
            case 2: {
                this.animal.method_19540(false);
                double dist = this.animal.method_5739((class_1297)target);
                if (dist <= (double)(this.animal.getAttackReach() * 2.0f) || this.canTargetSeeMe(target, (class_1314)this.animal)) {
                    this.animal.setStalking(false);
                    this.animal.method_19540(true);
                    this.state = State.AGGRESSIVE;
                    break;
                }
                this.handleMoveTowards(target, 1.0);
                break;
            }
            case 3: {
                this.animal.method_19540(true);
                this.handleMoveTowards(target, 1.0);
                if (this.attackCooldown == 0) {
                    if (!(target.method_5858((class_1297)this.animal) <= (double)this.animal.getAttackReach())) break;
                    this.attack(target);
                    this.recomputePathTicks += 5;
                    this.attackResetTime = this.attackCooldown;
                    break;
                }
                --this.attackCooldown;
            }
        }
    }

    private void handleMoveTowards(class_1309 target, double speed) {
        JSAnimalBase base;
        if (target.method_5858((class_1297)this.animal) <= (double)(this.animal.getAttackReach() / 2.0f) && target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            class_243 targetPos = target.method_19538();
            class_243 targetLook = target.method_5720().method_1029();
            double distanceAhead = 1.0;
            class_243 aheadPos = targetPos.method_1019(targetLook.method_1021(distanceAhead));
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.field_1352, aheadPos.field_1351, aheadPos.field_1350);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        path.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(5, 15);
        } else {
            --this.recomputePathTicks;
        }
    }

    protected void attack(class_1309 target) {
        this.animal.attack(target);
    }

    protected boolean extraCheckBeforeSwitch(class_1309 target, JSAnimalBase animal) {
        return true;
    }

    private boolean canTargetSeeMe(class_1309 target, class_1314 entity) {
        if (target.method_37908() != entity.method_37908()) {
            return false;
        }
        class_243 targetEyes = new class_243(target.method_23317(), target.method_23320(), target.method_23321());
        class_243 entityEyes = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        if (entityEyes.method_1022(targetEyes) > 64.0) {
            return false;
        }
        return target.method_37908().method_17742(new class_3959(targetEyes, entityEyes, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)target)).method_17783() == class_239.class_240.field_1333;
    }

    private boolean isTargetRunningAway(class_1309 target) {
        class_243 targetMove;
        double dist = this.animal.method_5739((class_1297)target);
        if (dist < 10.0) {
            return false;
        }
        class_243 toAnimal = this.animal.method_19538().method_1020(target.method_19538()).method_1029();
        return toAnimal.method_1026(targetMove = target.method_18798().method_1029()) < -0.25;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.callingTicks = this.maxCallingTicks;
        this.animal.setObserving(false);
        this.animal.method_5980(null);
        this.animal.setStalking(false);
        this.animal.method_19540(false);
        this.state = State.AGGRESSIVE;
    }

    private static enum State {
        CALLING,
        OBSERVING,
        STALKING,
        AGGRESSIVE;

    }
}

