/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSGrazeTask
extends JSTaskBase {
    private class_243 targetPos;
    private int grazeTicks = 0;

    public JSGrazeTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        class_2338 base = this.animal.method_24515();
        int range = 8;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                class_2338 pos = base.method_10069(dx, 0, dz);
                if (!this.animal.method_37908().method_8320(pos).method_27852(class_2246.field_10219) || !this.animal.method_37908().method_22347(pos.method_10084())) continue;
                this.targetPos = class_243.method_24953((class_2382)pos.method_10084());
                return true;
            }
        }
        return false;
    }

    public boolean canContinueRunning() {
        return this.targetPos != null && this.animal.getModules().getMetabolismModule().isHungry();
    }

    public void onStart() {
        if (this.targetPos != null) {
            this.animal.getNavigationController().moveTo(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
        }
    }

    public void tick() {
        if (this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 2.0f)) {
            ++this.grazeTicks;
            if (this.grazeTicks > 40) {
                class_2338 grassPos = class_2338.method_49638((class_2374)this.targetPos).method_10074();
                if (this.animal.method_37908().method_8320(grassPos).method_27852(class_2246.field_10219)) {
                    this.animal.method_37908().method_8652(grassPos, class_2246.field_10566.method_9564(), 3);
                }
                this.animal.getModules().getMetabolismModule().addFood((int)JSUtils.toTickMinutes(20.0f));
                this.targetPos = null;
                this.grazeTicks = 0;
            }
        }
    }

    public void onStop() {
        this.targetPos = null;
        this.grazeTicks = 0;
    }

    public void cleanUp() {
        this.targetPos = null;
        this.grazeTicks = 0;
    }
}

