/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.class_243;
import travelers.server.animal.entity.task.TaskPriority;

public class JSRandomStrollTask
extends JSTaskBase {
    private class_243 foundTargetPos;
    private int xRange = 8;
    private int yRange = 4;
    private int yVariation = 4;

    public JSRandomStrollTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public TaskPriority getPriority() {
        return TaskPriority.LOW;
    }

    public JSRandomStrollTask setYVariation(int yVariation) {
        this.yVariation = yVariation;
        return this;
    }

    public JSRandomStrollTask setRange(int xRange, int yRange) {
        this.xRange = xRange;
        this.yRange = yRange;
        return this;
    }

    public boolean canInterrupt() {
        return this.animal.shouldSleep() || this.animal.getFleeTarget() != null;
    }

    public boolean shouldRun() {
        JSAvianBase base;
        if (this.animal.method_6113() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead() || this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.getNavigationController().isInProgress()) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (jSAnimalBase instanceof JSAvianBase && ((base = (JSAvianBase)jSAnimalBase).isDiving() || base.method_5968() != null)) {
            return false;
        }
        return this.animal.getNavigationController().isDone() && this.random.nextDouble() > 0.4;
    }

    public boolean canContinueRunning() {
        JSAvianBase base;
        if (this.animal.method_6113() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead() || this.animal.method_5968() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (jSAnimalBase instanceof JSAvianBase && ((base = (JSAvianBase)jSAnimalBase).isDiving() || base.method_5968() != null)) {
            return false;
        }
        return this.animal.getNavigationController().isInProgress();
    }

    public void onStart() {
        if (this.foundTargetPos == null) {
            this.foundTargetPos = JSTaskUtils.findTargetPos(this.animal, this.xRange, this.yRange, this.yVariation);
            if (this.foundTargetPos != null) {
                CompletableFuture path = this.animal.getNavigationController().createPath(this.foundTargetPos.field_1352, this.foundTargetPos.field_1351, this.foundTargetPos.field_1350, 1);
                if (path != null) {
                    path.thenAccept(jsPath -> {
                        if (jsPath != null) {
                            this.animal.getNavigationController().moveTo(jsPath);
                        }
                    });
                }
            } else {
                this.stop();
            }
        }
    }

    public void tick() {
    }

    public void onStop() {
        this.animal.getNavigationController().stop();
        this.foundTargetPos = null;
    }
}

