/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.AlligatorAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class AlligatorAnimal
extends AbstractJSAnimal<AlligatorEntity> {
    public AlligatorAnimal() {
        super("alligator");
        this.setAnimator(new AlligatorAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<AlligatorEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(5.0f));
        geneticProperties.setDefaultGenes(JSGenetics.TROPICAL_COSMETIC);
        geneticProperties.setSpawnGeneticsDefault();
        geneticProperties.addSupportedGenes(JSGenetics.SIZE_SMALL, JSGenetics.SIZE_LARGE);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<AlligatorEntity> metabolismProperties) {
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, () -> Diets.CARNIVORE.get().add(Diets.PISCIVORE.get()));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<AlligatorEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<AlligatorEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, MesolimulusEntity.class, class_1422.class, class_1429.class, GoatEntity.class, OstrichEntity.class, GallimimusEntity.class, DryosaurusEntity.class, ProcompsognathusEntity.class, BonitoEntity.class);
        socialGroupProperties.addScaredOf(TylosaurusEntity.class);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<AlligatorEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(7563332, 4142898);
        itemProperties.setSpawnEggColorsMale(7036477, 2960168);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<AlligatorEntity> attributes, EntityBaseProperties<AlligatorEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(1.0);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setEntityFactory(AlligatorEntity::new);
        attributes.setCategory(class_1311.field_6300);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions((double)1.6f, (double)0.7f);
        attributes.setMovementSpeed((double)0.16f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)1.6f);
        attributes.setWaterEfficiency(1.0);
    }
}

