/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.avian.CearadactylusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class CearadactylusAnimal
extends AbstractJSAnimal<CearadactylusEntity> {
    public CearadactylusAnimal() {
        super("cearadactylus");
        this.setAnimator(new CearadactylusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<CearadactylusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.9f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.RAINFOREST_COSMETIC, JSGenetics.JUNGLE_COSMETIC, JSGenetics.STEPPE_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<CearadactylusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.PISCIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxStamina((int)JSUtils.toTicksMCDays(0.9f));
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.5f));
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<CearadactylusEntity> miscProperties) {
        miscProperties.setGuidebookScaling(new float[]{2.0f, 1.35f});
        miscProperties.setGuidebookOffset(new class_241(-1.1f, 0.5f), new class_241(-0.4f, -0.15f));
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxTurnRate(12.0f);
        miscProperties.setMaxHeadRotation(90.0f, 45.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("A pterosaur from the Early Cretaceous of Brazil. It had a long, toothed beak and is believed to have fed on fish. With a wingspan of around 4\u20135 meters, it was a capable flyer that likely soared over coastal environments.");
        miscProperties.setGuideBookSource("Brazil");
        miscProperties.setGuideBookScientificName("Cearadactylus atrox");
        miscProperties.setAdvancementTitle("Dive-Bombing Menace");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<CearadactylusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, ProcompsognathusEntity.class, DryosaurusEntity.class, TroodonEntity.class, GallimimusEntity.class, GoatEntity.class, OstrichEntity.class, class_1429.class);
        socialGroupProperties.addHerdTargets(CearadactylusEntity.class);
        socialGroupProperties.setMaxHerdSize(5);
        socialGroupProperties.setMaxDistanceToPackLeader(6000.0f);
        socialGroupProperties.setMinDistanceToPackLeader(1200.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<CearadactylusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(4733997, 6327720);
        itemProperties.setSpawnEggColorsMale(3353632, 5728351);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<CearadactylusEntity> attributes, EntityBaseProperties<CearadactylusEntity> base) {
        base.setAnimalType(AnimalType.BIRD);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setRenderScale((double)0.65f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setBabyAnimations();
        base.setSpecialRenderer();
        attributes.setPersistent();
        attributes.setEntityFactory(CearadactylusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(60.0);
        attributes.setDimensions((double)1.9f, (double)1.6f);
        attributes.setMovementSpeed((double)0.185f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.167f);
        attributes.setWaterEfficiency((double)0.6f);
        attributes.setAttackDamage(10.0);
        attributes.setAttackSpeed(1.0);
        attributes.setFollowRange(128.0);
        attributes.setTrackingRange(128.0);
    }
}

