/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class GoatEntity
extends JSAnimalBase {
    public static final class_2940<Integer> goat_variant = class_2945.method_12791(GoatEntity.class, (class_2941)class_2943.field_13327);

    public GoatEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 15));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this));
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.method_5968() != null || this.getFleeTarget() != null) {
            return (class_3414)JSV1Sounds.GOAT_ALARM.get();
        }
        return (class_3414)JSV1Sounds.GOAT_LIVING.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.GOAT_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.GOAT_HURT.get();
    }

    @Override
    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(goat_variant, (Object)GoatType.JURASSIC_PARK.ordinal());
    }

    @Override
    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setGoatVariant(GoatType.values()[pCompound.method_10550("js.goat_variant")]);
    }

    public GoatType getGoatVariant() {
        return GoatType.values()[(Integer)this.field_6011.method_12789(goat_variant)];
    }

    @Override
    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10569("js.goat_variant", this.getGoatVariant().ordinal());
    }

    @Override
    public class_1315 method_5943(class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        class_1959 biomeResult;
        class_6880 biome = level.method_22385().method_22393(this.method_24515());
        if (spawnType == class_3730.field_16465 || spawnType == class_3730.field_16471) {
            this.setGoatVariant(GoatType.getRandom());
        }
        if ((biomeResult = (class_1959)biome.comp_349()).method_33599(this.method_24515())) {
            this.setGoatVariant(GoatType.JPOG);
        } else if (!biomeResult.method_48163()) {
            this.setGoatVariant(GoatType.JURASSIC_PARK);
        } else if (biomeResult.method_8712() >= 0.8f) {
            this.setGoatVariant(GoatType.JWE);
        } else {
            this.setGoatVariant(GoatType.JURASSIC_WORLD);
        }
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    private void setGoatVariant(GoatType random) {
        this.field_6011.method_12778(goat_variant, (Object)random.ordinal());
    }

    public static boolean checkAnimalSpawnRules(class_1299<? extends class_1297> entityType, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        boolean flag = class_3730.method_54987((class_3730)spawnType) || GoatEntity.isBrightEnoughToSpawn((class_1920)level, pos);
        boolean state = level.method_8320(pos.method_10074()).method_26164(class_3481.field_35567);
        return state && flag;
    }

    protected static boolean isBrightEnoughToSpawn(class_1920 level, class_2338 pos) {
        return level.method_22335(pos, 0) > 8;
    }

    public static enum GoatType {
        JURASSIC_PARK("jp"),
        JPOG("jpog"),
        JWE("jwe"),
        JURASSIC_WORLD("jw");

        private final String typeName;
        private static final Random rng;

        private GoatType(String typeName) {
            this.typeName = typeName;
        }

        public static GoatType getRandom() {
            return GoatType.values()[rng.nextInt(GoatType.values().length)];
        }

        public String getTypeName() {
            return this.typeName;
        }

        static {
            rng = new Random();
        }
    }
}

