/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRoarTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class TyrannosaurusEntity
extends JSAnimalBase {
    public TyrannosaurusEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 15));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 4));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this).setRange(128));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this).observe().stalk());
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSRoarTask(this, JSAnimations.ROAR_1.soundAndLength((class_3414)JSV1Sounds.TYRANNOSAURUS_ROAR1.get(), 87, 0, 30), JSAnimations.ROAR_2.soundAndLength((class_3414)JSV1Sounds.TYRANNOSAURUS_ROAR2.get(), 120, 18, 22)).scareNearby());
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 30;
    }

    @Override
    public int shakeLength() {
        return 12;
    }

    @Override
    public float shakeAmount() {
        return 0.9f;
    }

    @Override
    public float shakeDistance() {
        return 60.0f;
    }

    @Override
    public float method_49476() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.BABY) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.getRenderScale() > 2.0f) {
            this.method_5783((class_3414)JSSounds.LARGE_CARNIVORE_STEP.get(), 2.0f, this.method_6017() - 0.1f);
            this.shakeCamera(this.getModules().getGrowthStageModule().getPercentage(), true);
        } else {
            super.method_5712(pos, state);
        }
    }

    protected float method_5867() {
        float speed = this.method_6029();
        return this.field_5994 + 7.8f * speed;
    }

    @Override
    @Nullable
    protected class_3414 getAttackSound() {
        return (class_3414)JSV1Sounds.TYRANNOSAURUS_ATTACK.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.TYRANNOSAURUS_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.TYRANNOSAURUS_DEATH.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)JSV1Sounds.TYRANNOSAURUS_LIVING.get();
    }
}

