/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.HashSet;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneExtractorMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.TravelersItemInterface;

public class GeneExtractorMachineEntity
extends GenericMachineEntity {
    public static final boolean removeGeneWhenExtract = true;
    public static final HashSet<class_1792> ACCEPTED_ITEMS = new HashSet();
    public static int maxExtractions = 3;
    private final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> GeneExtractorMachineEntity.this.progress;
                case 1 -> GeneExtractorMachineEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    GeneExtractorMachineEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GeneExtractorMachineEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int remainingExtractions = 3;
    private boolean isDisplayingItems = false;

    public GeneExtractorMachineEntity(class_2338 p_155229_, class_2680 p_155230_) {
        super(19, (class_2248)JSV1Blocks.GENE_EXTRACTOR.get(), (class_2591)JSV1BlockEntities.GENE_EXTRACTOR.get(), p_155229_, p_155230_);
        if (ACCEPTED_ITEMS.isEmpty()) {
            GeneExtractorMachineEntity.init();
        }
    }

    private static void init() {
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getItemProperties().isHasCoin() && !animal.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
            TravelersItemInterface items = animal.getItems();
            ACCEPTED_ITEMS.add((class_1792)items.getCoin().get());
        }
        for (JSPlantData value : JSGenetics.PLANT_GENETIC_INFORMATION.values()) {
            ACCEPTED_ITEMS.add((class_1792)value.coin.get());
        }
    }

    private void localTick(class_1937 lvl, GeneExtractorMachineEntity be) {
        if (lvl.field_9236 || ((class_1799)this.items.getFirst()).method_7960()) {
            return;
        }
        if (be.canOutput(be) && !this.isDisplayingItems && ACCEPTED_ITEMS.contains(((class_1799)this.items.getFirst()).method_7909())) {
            ++be.progress;
            if (be.progress >= be.maxProgress && !((class_1799)this.items.getFirst()).method_7960()) {
                class_1799 input = (class_1799)this.items.getFirst();
                this.remainingExtractions = input.method_57826((class_9331)JSDataComponents.GENE_EXTRACTOR_TRIES.get()) ? (Integer)input.method_57825((class_9331)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)0) : maxExtractions;
                if (this.remainingExtractions > 0) {
                    JSGeneData geneticData = JSGeneUtil.readFromStack(input);
                    for (int i = 0; i < geneticData.geneDataHolder.getGENE_SET().size(); ++i) {
                        JSGene gene = geneticData.geneDataHolder.getGENE_SET().get(i);
                        this.items.set(i + 1, (Object)((class_1792)JSGenetics.GENE_ITEMS.get(gene).get()).method_7854());
                    }
                    this.isDisplayingItems = true;
                }
            }
        }
        be.method_5431();
    }

    private boolean canOutput(GeneExtractorMachineEntity be) {
        class_1799 input = (class_1799)be.items.getFirst();
        if (!((class_1799)be.items.getFirst()).method_7960()) {
            JSGeneData data = JSGeneUtil.readFromStack(input);
            return data.getTotalCompletion() == 100 & !data.geneDataHolder.getGENE_SET().isEmpty();
        }
        return false;
    }

    public void onTookFromInputSlot(class_1799 stack) {
        class_1799 geneStack;
        if (!stack.method_7960() && this.remainingExtractions != 0 && this.remainingExtractions != maxExtractions) {
            stack.method_57379((class_9331)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)this.remainingExtractions);
        }
        for (int i = 1; i < this.items.size() && (geneStack = (class_1799)this.items.get(i)) != class_1799.field_8037; ++i) {
            geneStack.method_7934(1);
            this.items.set(i, (Object)geneStack);
        }
        this.progress = 0;
        this.isDisplayingItems = false;
    }

    public void onTookFromOutputSlot(class_1799 stack) {
        class_1799 geneStack;
        this.progress = 0;
        this.isDisplayingItems = false;
        --this.remainingExtractions;
        class_1799 inputStack = (class_1799)this.items.getFirst();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof GeneItem) {
            GeneItem item = (GeneItem)class_17922;
            JSGene gene = item.getGene();
            if (!inputStack.method_7960()) {
                JSGeneData geneticData = JSGeneUtil.readFromStack(inputStack);
                geneticData.removeGene(gene);
                JSGeneUtil.wipeStack(inputStack);
                JSGeneUtil.writeToStack(inputStack, geneticData);
            }
        }
        if (!inputStack.method_7960()) {
            if (this.remainingExtractions != 0) {
                inputStack.method_57379((class_9331)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)this.remainingExtractions);
            } else {
                inputStack.method_7934(1);
            }
        }
        this.items.set(0, (Object)inputStack);
        for (int i = 1; i < this.items.size() && (geneStack = (class_1799)this.items.get(i)) != class_1799.field_8037; ++i) {
            geneStack.method_7934(1);
            this.items.set(i, (Object)geneStack);
        }
    }

    @Nullable
    public class_1703 createMenu(int p_39954_, @NotNull class_1661 p_39955_, @NotNull class_1657 p_39956_) {
        return new GeneExtractorMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof GeneExtractorMachineEntity) {
            GeneExtractorMachineEntity ge = (GeneExtractorMachineEntity)be;
            ge.localTick(level, ge);
        }
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }
}

