/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.ResultType;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneticAnalyzerMachineMenu;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.misc.AnimalType;

public class GeneticAnalyzerMachineEntity
extends GenericMachineEntity {
    private final class_3913 data;
    private static final HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> resultPossibilityHashMap = new HashMap();
    private class_1799 currentAnalyzerItem = class_1799.field_8037;
    private int currentAnalyzingSlotIndex = -1;
    private int progress = 0;
    private int maxProgress = 100;
    private class_1799 resultItem = class_1799.field_8037;

    public GeneticAnalyzerMachineEntity(class_2338 pos, class_2680 state) {
        super(19, (class_2248)JSV1Blocks.GENETIC_ANALYZER.get(), (class_2591)JSV1BlockEntities.GENETIC_ANALYZER.get(), pos, state);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> GeneticAnalyzerMachineEntity.this.progress;
                    case 1 -> GeneticAnalyzerMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneticAnalyzerMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GeneticAnalyzerMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
        if (resultPossibilityHashMap.isEmpty()) {
            GeneticAnalyzerMachineEntity.init();
        }
    }

    private static void init() {
        JSGenetics.PLANT_GENETIC_INFORMATION.forEach((string, jsPlantData) -> {
            resultPossibilityHashMap.putIfAbsent(ResultType.PLANT, new HashMap());
            HashMap resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.PLANT, new HashMap());
            for (Era supportedEra : jsPlantData.supported_eras) {
                ArrayList<AnalyzerResult> list = resultHashMap.getOrDefault((Object)supportedEra, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((class_1792)jsPlantData.coin.get(), 15), new AnalyzerChanceItem(class_1802.field_8110, 30), new AnalyzerChanceItem(class_1802.field_8858, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(supportedEra, list);
            }
            resultPossibilityHashMap.put(ResultType.PLANT, resultHashMap);
        });
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            ArrayList<AnalyzerResult> list;
            HashMap resultHashMap;
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getItems().getCoin() == null) continue;
            AnimalType type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            Era era = animal.getAnimalAttributes().getMiscProperties().getEra();
            if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH || type == AnimalType.AMPHIBIAN) {
                resultPossibilityHashMap.putIfAbsent(ResultType.AQUATIC, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.AQUATIC, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(class_1802.field_8110, 15), new AnalyzerChanceItem(class_1802.field_8858, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else if (type == AnimalType.SYNAPSID || type == AnimalType.INSECT || type == AnimalType.CEPHALOPOD) {
                resultPossibilityHashMap.putIfAbsent(ResultType.BUG, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.BUG, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(class_1802.field_8110, 15), new AnalyzerChanceItem(class_1802.field_8831, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else {
                resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(class_1802.field_8110, 15), new AnalyzerChanceItem(class_1802.field_20412, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
            }
            if (type != AnimalType.AMPHIBIAN) continue;
            resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
            resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
            list = resultHashMap.getOrDefault((Object)era, new ArrayList());
            list.add(new AnalyzerResult(new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(class_1802.field_8110, 15), new AnalyzerChanceItem(class_1802.field_20412, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
            resultHashMap.put(era, list);
            resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
        }
    }

    public void localTick(class_1937 level) {
        block5: {
            block6: {
                block4: {
                    if (level.field_9236) {
                        return;
                    }
                    if (this.currentAnalyzingSlotIndex != -1 && !this.currentAnalyzerItem.method_7960()) break block4;
                    this.progress = 0;
                    for (int i = 0; i < 9; ++i) {
                        class_1799 stack = (class_1799)this.getItems().get(i);
                        if (!this.isValidItem(stack)) continue;
                        this.currentAnalyzerItem = stack;
                        this.currentAnalyzingSlotIndex = i;
                        this.progress = 0;
                        this.resultItem = class_1799.field_8037;
                        return;
                    }
                    break block5;
                }
                if (!this.resultItem.method_7960()) break block6;
                if (this.progress++ < this.maxProgress) break block5;
                this.createResult(level);
                this.progress = 0;
                break block5;
            }
            for (int i = 9; i < 19; ++i) {
                class_1799 slotStack = (class_1799)this.getItems().get(i);
                if (slotStack.method_7960()) {
                    this.getItems().set(i, (Object)this.resultItem.method_7972());
                    this.consumeInput();
                    return;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)this.resultItem) || slotStack.method_7947() + this.resultItem.method_7947() > slotStack.method_7914()) continue;
                slotStack.method_7933(this.resultItem.method_7947());
                this.consumeInput();
                return;
            }
        }
    }

    private void consumeInput() {
        this.currentAnalyzerItem.method_7934(1);
        if (this.currentAnalyzerItem.method_7960()) {
            this.currentAnalyzerItem = class_1799.field_8037;
            this.currentAnalyzingSlotIndex = -1;
        }
        this.resultItem = class_1799.field_8037;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createResult(class_1937 level) {
        class_1792 data;
        class_1792 class_17922 = this.currentAnalyzerItem.method_7909();
        if (class_17922 instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)class_17922;
            data = (class_9280)this.currentAnalyzerItem.method_57824(class_9334.field_49637);
            boolean isPlant = false;
            if (data != null) {
                isPlant = data.equals((Object)SampleColour.PLANT.model());
            }
            String component = (String)this.currentAnalyzerItem.method_57825((class_9331)JSDataComponents.SPECIES_NAME.get(), (Object)"");
            if (isPlant) {
                Supplier<class_1792> coin;
                JSPlantData plantData = JSGenetics.PLANT_GENETIC_INFORMATION.get(class_2960.method_12838((String)component, (char)':').method_12832());
                if (plantData == null || (coin = plantData.coin) == null) return;
                this.resultItem = ((class_1792)coin.get()).method_7854();
                return;
            }
            if (component.contains("minecraft:")) {
                try {
                    Supplier<class_1792> coin;
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_12838((String)component, (char)':'));
                    JSDefaultEntityData geneData = JSGenetics.ENTITY_DEFAULT_GENE_DATA.get(entityType);
                    if (geneData == null || (coin = geneData.coin()) == null) return;
                    this.resultItem = new class_1799((class_1935)coin.get());
                    JSGeneUtil.writeToStack(this.resultItem, geneData.geneData());
                    return;
                }
                catch (Exception e) {
                    return;
                }
            } else {
                JSAnimal<?> animal = JSAnimals.getAnimal((String)this.currentAnalyzerItem.method_57825((class_9331)JSDataComponents.SPECIES_NAME.get(), (Object)""));
                if (animal == null || animal.getItems().getCoin() == null) return;
                class_1792 coin = (class_1792)animal.getItems().getCoin().get();
                JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                this.resultItem = new class_1799((class_1935)coin);
                genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                JSGeneUtil.writeToStack(this.resultItem, genes);
            }
            return;
        }
        data = this.currentAnalyzerItem.method_7909();
        if (!(data instanceof FossilItem)) {
            return;
        }
        FossilItem fossilItem = (FossilItem)data;
        ResultType type = fossilItem.getResult().getResultType();
        ArrayList<AnalyzerResult> results = resultPossibilityHashMap.get((Object)type).get((Object)fossilItem.getEra());
        if (results == null || results.isEmpty()) {
            return;
        }
        AnalyzerResult result = results.get(level.field_9229.method_43048(results.size()));
        int totalWeight = 0;
        for (AnalyzerChanceItem item : result.getChanceItems()) {
            totalWeight += item.chance();
        }
        int roll = level.field_9229.method_43048(totalWeight);
        int sum = 0;
        for (AnalyzerChanceItem item : result.getChanceItems()) {
            Object geneData;
            if (roll >= (sum += item.chance())) continue;
            this.resultItem = new class_1799((class_1935)item.item());
            class_1792 class_17923 = item.item();
            if (class_17923 instanceof DnaItem) {
                DnaItem dnaItem = (DnaItem)class_17923;
                geneData = dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                JSGeneData newData = ((JSGeneData)geneData).copy();
                newData.setBaseQuality(this.random.nextInt(20, 40));
                this.resultItem.method_57379((class_9331)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new class_2487()));
                return;
            }
            geneData = item.item();
            if (!(geneData instanceof PlantDnaItem)) return;
            PlantDnaItem dnaItem = (PlantDnaItem)((Object)geneData);
            geneData = dnaItem.getGeneData();
            JSGeneData newData = ((JSGeneData)geneData).copy();
            newData.setGeneType(GeneType.PLANT);
            newData.setBaseQuality(this.random.nextInt(20, 40));
            this.resultItem.method_57379((class_9331)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new class_2487()));
            return;
        }
    }

    private boolean isValidItem(class_1799 stack) {
        FossilItem fossilItem;
        Object era;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FossilItem && JSAnimals.hasEra((Era)((Object)(era = (fossilItem = (FossilItem)class_17922).getEra())))) {
            ResultType type = fossilItem.getResult().getResultType();
            return resultPossibilityHashMap.containsKey((Object)type);
        }
        era = stack.method_7909();
        if (era instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)era;
            boolean hasNone = ((String)stack.method_57825((class_9331)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
            return !hasNone;
        }
        return false;
    }

    @Nullable
    public class_1703 createMenu(int id, @NotNull class_1661 playerInv, @NotNull class_1657 player) {
        return new GeneticAnalyzerMachineMenu(id, playerInv, this, this.data);
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof GeneticAnalyzerMachineEntity) {
            GeneticAnalyzerMachineEntity geneticAnalyzer = (GeneticAnalyzerMachineEntity)be;
            geneticAnalyzer.localTick(level);
        }
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }

    public static HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> getResultPossibilityHashMap() {
        return resultPossibilityHashMap;
    }

    private static class AnalyzerResult {
        private final AnalyzerChanceItem[] chanceItems;

        public AnalyzerResult(AnalyzerChanceItem ... chanceItems) {
            this.chanceItems = chanceItems;
        }

        public AnalyzerChanceItem[] getChanceItems() {
            return this.chanceItems;
        }
    }

    private record AnalyzerChanceItem(class_1792 item, int chance) {
    }
}

