/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class AraucarioxylonTrunkGrower
extends class_5141 {
    public static final MapCodec<AraucarioxylonTrunkGrower> CODEC = RecordCodecBuilder.mapCodec(instance -> AraucarioxylonTrunkGrower.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, AraucarioxylonTrunkGrower::new));

    public AraucarioxylonTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return (class_5142)JSV1TrunkPlacerTypes.ARAUCARIOXYLON.get();
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> blockSetter, @NotNull class_5819 random, int freeTreeHeight, class_2338 pos, @NotNull class_4643 config) {
        class_2338 trunkPos;
        int i;
        AraucarioxylonTrunkGrower.method_27400((class_3746)level, blockSetter, (class_5819)random, (class_2338)pos.method_10074(), (class_4643)config);
        int trunkHeight = 30 + random.method_43048(20);
        int branchLength = (trunkHeight - 2) / 8;
        int step = 15;
        for (i = 0; i < trunkHeight; ++i) {
            trunkPos = pos.method_10086(i);
            this.method_35375(level, blockSetter, random, trunkPos, config);
            if (i > 2 && i < trunkHeight - 2) {
                if (--step <= 0) {
                    step = 10;
                    branchLength = Math.max(1, branchLength - 1);
                }
                if (step == 5 || step == 10) {
                    this.placeBranches(level, blockSetter, trunkPos, branchLength);
                }
            }
            if (i != trunkHeight - 1) continue;
            this.placeLeavesAround(level, blockSetter, random, trunkPos, config);
            blockSetter.accept(trunkPos.method_10086(2), ((class_2248)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).method_9564());
        }
        step = 15;
        branchLength = (trunkHeight - 2) / 8;
        for (i = 0; i < trunkHeight; ++i) {
            if (i <= 2 || i >= trunkHeight - 2) continue;
            if (--step <= 0) {
                step = 10;
                branchLength = Math.max(1, branchLength - 1);
            }
            if (step != 5 && step != 10) continue;
            trunkPos = pos.method_10086(i);
            this.placeBranchLeaves(level, blockSetter, random, trunkPos, config, branchLength);
        }
        return ImmutableList.of();
    }

    private void placeBranches(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_2338 base, int length) {
        class_2680 log = ((class_2248)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).method_9564();
        for (int j = 0; j < length; ++j) {
            blockSetter.accept(base.method_10087(j).method_10076(j), log);
            blockSetter.accept(base.method_10087(j).method_10089(j), log);
            blockSetter.accept(base.method_10087(j).method_10077(j), log);
            blockSetter.accept(base.method_10087(j).method_10088(j), log);
        }
    }

    private void placeBranchLeaves(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, class_2338 base, class_4643 config, int length) {
        for (int j = 0; j < length; ++j) {
            this.placeLeavesAround(level, blockSetter, random, base.method_10087(j).method_10076(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.method_10087(j).method_10089(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.method_10087(j).method_10077(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.method_10087(j).method_10088(j), config);
        }
    }

    private void placeLeavesAround(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, class_2338 pos, class_4643 config) {
        for (class_2338 offset : new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (!this.isValid(level, offset)) continue;
            blockSetter.accept(offset, ((class_2248)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).method_9564());
        }
    }

    private boolean isValid(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, class_4970.class_4971::method_26215);
    }
}

