/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.renderer.entity.AnimalClientAnimator;
import jp.jurassicsaga.client.base.renderer.entity.HaybaleRenderer;
import jp.jurassicsaga.client.base.renderer.entity.JSBoatRenderer;
import jp.jurassicsaga.client.base.renderer.entity.JSEggRenderer;
import jp.jurassicsaga.client.base.renderer.entity.MeatRenderer;
import jp.jurassicsaga.client.base.renderer.entity.PaddockSignRenderer;
import jp.jurassicsaga.client.base.renderer.entity.VenomSpitRenderer;
import jp.jurassicsaga.client.v1.renderer.JSV1Renderers;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.entity.JSEntities;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import travelers.client.render.animal.azure.TravelersAzureClientAnimal;
import travelers.client.render.animal.azure.obj.TravelersAzureClientAnimalRegistry;
import travelers.util.helper.ClientPlatformHelper;

public class JSRenderers {
    public static final ModelLayerLocation VENOM_SPIT = new ModelLayerLocation(JSCommon.createId("venom_spit"), "main");
    public static final ModelLayerLocation HAYBALE = new ModelLayerLocation(JSCommon.createId("haybale"), "main");
    public static final ModelLayerLocation MEAT = new ModelLayerLocation(JSCommon.createId("meat"), "main");

    public static void init() {
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.EGG.get(), JSEggRenderer::new);
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.BOAT.get(), a -> new JSBoatRenderer(a, false));
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.BOAT_CHEST.get(), a -> new JSBoatRenderer(a, true));
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.PADDOCK_SIGN.get(), PaddockSignRenderer::new);
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.MEAT.get(), MeatRenderer::new);
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.HAYBALE.get(), HaybaleRenderer::new);
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.VENOM_SPIT.get(), VenomSpitRenderer::new);
        ClientPlatformHelper.registerEntityRenders(() -> JSEntities.SEAT.get(), JSRenderers.nullRenderer());
        ClientPlatformHelper.registerBlockEntityRenders(() -> JSBlockEntities.SIGN.get(), SignRenderer::new);
        ClientPlatformHelper.registerBlockEntityRenders(() -> JSBlockEntities.HANGING_SIGN.get(), HangingSignRenderer::new);
        JSV1Renderers.init();
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            TravelersAzureClientAnimalRegistry.register(animal, (TravelersAzureClientAnimal)new AnimalClientAnimator(animal));
        }
    }

    private static EntityRendererProvider<Entity> nullRenderer() {
        return context -> new EntityRenderer<Entity>(context){

            public ResourceLocation getTextureLocation(Entity entity) {
                return null;
            }
        };
    }
}

