/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.layer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.locator.ResourceLocator;

public class LuxLayer
implements AzRenderLayer<UUID, SmartAnimalBase> {
    public static final Map<UUID, Float> previousBrightness = new HashMap<UUID, Float>();

    public void preRender(AzRendererPipelineContext<UUID, SmartAnimalBase> azRendererPipelineContext) {
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context) {
        Object object = context.animatable();
        if (object instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)((Object)object);
            if (base.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                return;
            }
            if (!base.getModules().getGeneticModule().getGeneData().hasGene(JSGenetics.LUX)) {
                return;
            }
            float brightness = this.getLerpedBrightness(base);
            if (brightness <= 0.0f) {
                return;
            }
            ResourceLocator resourceLocator = base.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator();
            if (resourceLocator instanceof JSAnimalBaseLocator) {
                JSAnimalBaseLocator locator = (JSAnimalBaseLocator)resourceLocator;
                AzRendererPipeline renderPipeline = context.rendererPipeline();
                ResourceLocation textureLocation = locator.getLuxLocation(base);
                RenderType renderType = RenderType.entityTranslucentEmissive((ResourceLocation)textureLocation);
                RenderType prevRenderType = context.renderType();
                int prevPackedLight = context.packedLight();
                VertexConsumer prevVertexConsumer = context.vertexConsumer();
                context.setRenderType(renderType);
                context.setPackedLight(0xF00000);
                context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
                int color = this.getHueShiftColor(base.getModules().getGeneticModule().getGeneData().getGeneSeed(), brightness);
                context.setRenderColor(color);
                renderPipeline.reRender(context);
                context.setRenderType(prevRenderType);
                context.setPackedLight(prevPackedLight);
                context.setVertexConsumer(prevVertexConsumer);
            }
        }
    }

    public float getLerpedBrightness(JSAnimalBase base) {
        UUID id = base.getUUID();
        boolean isDay = base.level().getDayTime() % 24000L < 12000L;
        float brightnessSky = isDay ? (float)base.level().getBrightness(LightLayer.SKY, base.blockPosition()) : 0.0f;
        float brightnessGround = base.level().getBrightness(LightLayer.BLOCK, base.blockPosition());
        float blockLight = Math.min(15.0f, brightnessGround + brightnessSky);
        float invertedBlockLight = 15.0f - blockLight;
        float previous = previousBrightness.getOrDefault(id, Float.valueOf(invertedBlockLight)).floatValue();
        float lerped = Mth.lerp((float)0.0025f, (float)previous, (float)invertedBlockLight);
        previousBrightness.put(id, Float.valueOf(lerped));
        return lerped;
    }

    public int getHueShiftColor(int seed, float brightness) {
        Random random = new Random(seed);
        float brightnessFactor = Mth.clamp((float)(brightness / 15.0f), (float)0.0f, (float)1.0f);
        float hueShift = random.nextFloat();
        float saturation = Mth.lerp((float)brightnessFactor, (float)1.0f, (float)(random.nextFloat(0.1f) + 0.45f));
        int rgb = Color.HSBtoRGB(hueShift, saturation, brightnessFactor);
        int alpha = (int)(brightnessFactor * 255.0f);
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public void renderForBone(AzRendererPipelineContext azRendererPipelineContext, AzBone azBone) {
    }
}

