/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.EntityInspectPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalPage;
import jp.jurassicsaga.client.base.screen.obj.widget.GuidebookTab;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuidebookScreen
extends Screen {
    private final int entityId;
    private String pageName = "journal";
    private static final ResourceLocation BG_LOCATION = JSCommon.createId("textures/gui/guidebook/background.png");
    private static final HashMap<String, GuidebookPage> PAGES = new HashMap();
    private final List<AbstractWidget> buttons = Lists.newArrayList();

    public GuidebookScreen(int i) {
        super((Component)Component.translatable((String)"js.screen.empty"));
        this.entityId = i;
        if (i != -1) {
            this.pageName = "entityInspect";
        }
        PAGES.put("entityInspect", new EntityInspectPage(this));
        PAGES.put("journal", new JournalPage(this));
        PAGES.put("help", new JournalPage(this));
    }

    public void init() {
        super.init();
        int i = this.width / 2;
        int j = this.height / 2;
        for (AbstractWidget button : this.buttons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.buttons.clear();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.init();
        }
        if (this.pageName.equals("entityInspect")) {
            this.addButton((AbstractWidget)new GuidebookTab(false, i - 8 - 200, j - 8 + 105, 25, 12, (Component)Component.empty(), press -> {
                this.pageName = "journal";
                this.init();
            }, JSCommon.createId("container/guidebook/arrow_left_hover"), JSCommon.createId("container/guidebook/arrow_left")));
        } else {
            if (this.entityId != -1) {
                this.addButton((AbstractWidget)new GuidebookTab(false, i - 8 - 200, j - 8 - 95, 25, 12, (Component)Component.empty(), press -> {
                    this.pageName = "entityInspect";
                    this.init();
                }, JSCommon.createId("container/guidebook/arrow_right_hover"), JSCommon.createId("container/guidebook/arrow_right")));
            }
            this.addButton((AbstractWidget)new GuidebookTab(false, i - 8 - 197, j - 8 + 102, 18, 18, (Component)Component.empty(), press -> {
                this.pageName = "help";
                this.init();
            }, JSCommon.createId("container/guidebook/search"), JSCommon.createId("container/guidebook/search")));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.width / 2;
        int j = this.height / 2;
        int width = 347;
        int height = 246;
        guiGraphics.blit(BG_LOCATION, i - width / 2, j - height / 2, 0.0f, 0.0f, width, height, width, height);
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.render(i, j, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void tick() {
        super.tick();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.tick();
        }
    }

    public void setPage(String pageName) {
        this.pageName = pageName;
        this.init();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyReleased(keyCode, scanCode, modifiers);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public Font getFont() {
        return this.font;
    }

    public void addButton(AbstractWidget button) {
        this.addRenderableWidget((GuiEventListener)button);
        this.buttons.add(button);
    }

    public int getEntityId() {
        return this.entityId;
    }
}

