/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo;

import com.mojang.blaze3d.platform.InputConstants;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.JSCommonClient;
import jp.jurassicsaga.client.base.particle.VenomParticle;
import jp.jurassicsaga.client.base.renderer.JSRenderers;
import jp.jurassicsaga.client.base.renderer.entity.JSBoatRenderer;
import jp.jurassicsaga.client.base.renderer.layer.LuxLayer;
import jp.jurassicsaga.client.base.renderer.model.HaybaleModel;
import jp.jurassicsaga.client.base.renderer.model.MeatModel;
import jp.jurassicsaga.client.base.renderer.model.VenomSpitModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSBoatModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSChestBoatModel;
import jp.jurassicsaga.neo.JSNeoClientPlatform;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.networking.obj.ShiftKeyPacket;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.particle.JSParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="jurassicsaga", dist={Dist.CLIENT})
public class JSModClient {
    public JSModClient(IEventBus modEventBus, ModContainer modContainer) {
        JSCommonClient.init();
    }

    @EventBusSubscriber(modid="jurassicsaga", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (JSBoatEntity.CustomType boat$type : JSBoatEntity.CustomType.values()) {
                event.registerLayerDefinition(JSBoatRenderer.createBoatModelName(boat$type), JSBoatModel::createBodyModel);
                event.registerLayerDefinition(JSBoatRenderer.createChestBoatModelName(boat$type), JSChestBoatModel::createBodyModel);
            }
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)JSParticles.VENOM_SPIT.get(), VenomParticle.Provider::new);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnEggColors(RegisterColorHandlersEvent.Item event) {
            for (GenderSpawnEgg egg : GenderSpawnEgg.getMOD_EGGS()) {
                event.register((itemStack, layer) -> {
                    JSGeneData geneData = JSGeneUtil.readFromStack(itemStack);
                    if (geneData.getFirstCosmetic().isPresent()) {
                        JSCosmeticGene cosmeticGene = (JSCosmeticGene)geneData.getFirstCosmetic().get();
                        return FastColor.ARGB32.opaque((int)(layer == 0 ? cosmeticGene.getColor1() : cosmeticGene.getColor2()));
                    }
                    Integer id = (Integer)itemStack.get((DataComponentType)JSDataComponents.SPAWN_TYPE.get());
                    GenderSpawnEgg.SpawnEggMode mode = GenderSpawnEgg.getSpawnEggMode(id);
                    if (mode == GenderSpawnEgg.SpawnEggMode.FEMALE) {
                        return FastColor.ARGB32.opaque((int)(layer == 0 ? egg.backgroundColorFemale : egg.highlightColorFemale));
                    }
                    return FastColor.ARGB32.opaque((int)(layer == 0 ? egg.backGroundColorMale : egg.highlightColorMale));
                }, new ItemLike[]{egg});
            }
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            for (JSNeoClientPlatform.ScreenRecord<? extends AbstractContainerMenu, ? extends Screen> screenRecord : JSNeoClientPlatform.screenList) {
                ModEvents.registerScreen(event, screenRecord);
            }
        }

        @SubscribeEvent
        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(JSRenderers.VENOM_SPIT, VenomSpitModel::createBodyLayer);
            event.registerLayerDefinition(JSRenderers.MEAT, MeatModel::createBodyLayer);
            event.registerLayerDefinition(JSRenderers.HAYBALE, HaybaleModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            for (JSAnimal<?> value : JSAnimals.getAnimals()) {
                if (!value.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
                event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("signs/paddock/" + value.getAnimalAttributes().getAnimalName()))));
            }
        }

        private static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(RegisterMenuScreensEvent event, JSNeoClientPlatform.ScreenRecord<?, ?> raw) {
            JSNeoClientPlatform.ScreenRecord<?, ?> rec = raw;
            event.register(rec.getType().get(), rec.getConstructor()::create);
        }
    }

    @EventBusSubscriber(modid="jurassicsaga", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class GameEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            boolean newDown;
            long window;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (Minecraft.getInstance().level != null) {
                Minecraft.getInstance().level.entitiesForRendering().forEach(entity -> {
                    if (entity.isRemoved() || !entity.isAlive()) {
                        LuxLayer.previousBrightness.remove(entity.getUUID());
                    }
                });
            }
            if ((window = mc.getWindow().getWindow()) == 0L) {
                return;
            }
            boolean bl = newDown = InputConstants.isKeyDown((long)window, (int)340) || InputConstants.isKeyDown((long)window, (int)344);
            if (newDown != JSCommon.isShiftKeyDown) {
                JSCommon.isShiftKeyDown = newDown;
                PacketDistributor.sendToServer((CustomPacketPayload)new ShiftKeyPacket(newDown), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

