/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import com.google.common.base.Supplier;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class JSCraftingProvider
extends RecipeProvider
implements IConditionBuilder {
    public JSCraftingProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.buildAnimalRecipes(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)JSItems.GUIDEBOOK.get()), (int)1).requires((ItemLike)Items.BOOK).requires(JSItemTags.FOSSIL).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.BOOK), JSCraftingProvider.has((ItemLike)Items.BOOK)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Items.SYRINGE.get()), (int)16).requires((ItemLike)Items.GLASS).requires((ItemLike)Items.IRON_INGOT).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.THATCH.get()), (int)2).requires((ItemLike)Items.SHORT_GRASS, 4).requires((ItemLike)Items.SUGAR_CANE, 4).requires((ItemLike)Items.STICK).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.SHORT_GRASS), JSCraftingProvider.has((ItemLike)Items.SHORT_GRASS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.IRON_PILLAR.get()), (int)2).requires((ItemLike)Items.IRON_BLOCK, 2).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_BLOCK), JSCraftingProvider.has((ItemLike)Items.IRON_BLOCK)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()), (int)2).requires((ItemLike)Items.BRICKS, 3).requires((ItemLike)Items.IRON_INGOT, 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.BRICKS), JSCraftingProvider.has((ItemLike)Items.BRICKS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.CAMO_NET.get()), (int)8).requires((ItemLike)Items.STICK, 5).requires(Ingredient.of((TagKey)ItemTags.LEAVES), 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.BRICKS), JSCraftingProvider.has((ItemLike)Items.BRICKS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.REINFORCED_GLASS.get()), (int)2).requires((ItemLike)JSV1Blocks.CLEAR_GLASS.get(), 1).requires((ItemLike)Items.IRON_INGOT, 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.CLEAR_GLASS.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.CLEAR_GLASS.get()))).save(recipeOutput);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.ROOF_TILES.get()})).unlockedBy("has_roof_tiles", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()))).save(recipeOutput);
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()));
        this.stairSlabColoredGroup(recipeOutput, JSV1Blocks.COLORED_ROOF_TILES_STAIRS, JSV1Blocks.COLORED_ROOF_TILES_SLAB, JSV1Blocks.COLORED_ROOF_TILES);
        this.colorGroup(recipeOutput, JSV1Blocks.COLORED_ROOF_TILES, (Block)JSV1Blocks.ROOF_TILES.get());
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.CORRUGATED_IRON.get()})).unlockedBy("has_corrugated_iron", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()))).save(recipeOutput);
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()));
        this.colorGroup(recipeOutput, JSV1Blocks.COLORED_CORRUGATED_IRONS, (Block)JSV1Blocks.CORRUGATED_IRON.get());
        this.stairSlabColoredGroup(recipeOutput, JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR, JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB, JSV1Blocks.COLORED_CORRUGATED_IRONS);
        this.colorGroup(recipeOutput, JSV1Blocks.COLORED_GLASS_DOORS, (Block)JSV1Blocks.GLASS_DOOR.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()), (int)3).pattern("CS").pattern("SC").define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Items.SAND).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.SAND), JSCraftingProvider.has((ItemLike)Items.SAND)).save(recipeOutput);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.BIG_TILE.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()))).save(recipeOutput);
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()), (int)8).pattern("CCC").pattern("CBC").pattern("CCC").define(Character.valueOf('C'), JSItemTags.CONCRETE).define(Character.valueOf('B'), (ItemLike)Items.IRON_BARS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_BARS), JSCraftingProvider.has((ItemLike)Items.IRON_BARS)).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()), (int)8).pattern("CC").pattern("CC").define(Character.valueOf('C'), (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_CRACKED.BLOCK.get()), (int)1).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_CRACKED.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_CRACKED.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_CRACKED.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_CRACKED.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.BLOCK.get()), (int)1).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get(), 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY.BLOCK.get()), (int)8).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get(), 8).requires(JSItemTags.MOSS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_MOSSY.BLOCK.get()), (int)8).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), 8).requires(JSItemTags.MOSS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_MOSSY.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_MOSSY.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_MOSSY.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_MOSSY.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.BLOCK.get()), (int)2).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get(), 8).requires(JSItemTags.MOSS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()), (int)2).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), 2).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        this.stairSlabWallStonecutter(recipeOutput, (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.SLAB.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.STAIRS.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.WALL.get(), (Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()), (int)3).pattern("C").pattern("C").pattern("C").define(Character.valueOf('C'), (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED.get()), (int)1).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get(), 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY.get()), (int)8).requires((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get(), 8).requires(JSItemTags.MOSS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()), (int)3).pattern("CS").pattern("SC").define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Items.DIRT).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.COBBLESTONE), JSCraftingProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.MIXED_PATH.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()))).save(recipeOutput);
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()), (int)8).pattern("CS").pattern("SC").define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Items.IRON_INGOT).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.COBBLESTONE), JSCraftingProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()), (int)3).pattern("CS").pattern("SC").define(Character.valueOf('C'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('S'), (ItemLike)Items.IRON_BARS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_BARS), JSCraftingProvider.has((ItemLike)Items.IRON_BARS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()), (int)3).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)Items.IRON_BARS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_BARS), JSCraftingProvider.has((ItemLike)Items.IRON_BARS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.CLEAR_GLASS.get()), (int)3).pattern("GG").pattern("GG").define(Character.valueOf('G'), (ItemLike)Items.GLASS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.GLASS), JSCraftingProvider.has((ItemLike)Items.GLASS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.GLASS_DOOR.get()), (int)3).pattern("#GG").pattern("#GG").pattern("#GG").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.GLASS_PANE), JSCraftingProvider.has((ItemLike)Items.GLASS_PANE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.GRID_DOOR.get()), (int)2).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Items.IRON_BARS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_BARS), JSCraftingProvider.has((ItemLike)Items.IRON_BARS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.SECURE_GRID_DOOR.get()), (int)1).requires((ItemLike)JSV1Blocks.GRID_DOOR.get(), 1).requires((ItemLike)Items.IRON_INGOT, 2).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.BRICKS), JSCraftingProvider.has((ItemLike)Items.BRICKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)JSV1Blocks.THATCH_SLAB.get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)JSV1Blocks.THATCH.get()).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.THATCH.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.THATCH.get()))).save(recipeOutput);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.THATCH_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.THATCH.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.THATCH.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.THATCH.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Items.EMPTY_TEST_TUBE.get()), (int)16).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Items.GLASS).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.GLASS), JSCraftingProvider.has((ItemLike)Items.GLASS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Blocks.GENETIC_ANALYZER.get()), (int)1).pattern("PBE").pattern("GAL").pattern("IIL").define(Character.valueOf('P'), ItemTags.WOODEN_PRESSURE_PLATES).define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('E'), (ItemLike)JSV1Items.SYRINGE.get()).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('A'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('L'), (ItemLike)Items.LEVER).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Blocks.GENE_EXTRACTOR.get()), (int)1).pattern("CPI").pattern("LBG").pattern("RSS").define(Character.valueOf('C'), (ItemLike)Items.GREEN_DYE).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('B'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)Items.STONE_BUTTON).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Blocks.DNA_MODIFIER.get()), (int)1).pattern("CII").pattern("LBG").pattern("RSS").define(Character.valueOf('C'), (ItemLike)Items.GREEN_DYE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('B'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)Items.STONE_BUTTON).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Blocks.INCUBATOR.get()), (int)1).pattern("NGI").pattern("LGP").pattern("LBR").define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LEVER).define(Character.valueOf('B'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)((ItemLike)JSV1Blocks.CULTIVATOR.get()), (int)1).pattern("IDR").pattern("IPS").pattern("IIS").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('D'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('P'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('S'), (ItemLike)Items.STONE_BUTTON).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)JSV1Blocks.BUG_ZAPPER.get()), (int)1).pattern(" C ").pattern("IFI").pattern(" I ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('F'), (ItemLike)Items.SOUL_TORCH).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.IRON_INGOT), JSCraftingProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)JSV1Blocks.HERBIVORE_FEEDER.get()), (int)1).pattern("FPF").pattern("ICI").pattern("FPF").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.CHEST).define(Character.valueOf('F'), (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).define(Character.valueOf('P'), (ItemLike)Items.PISTON).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)JSV1Blocks.CARNIVORE_FEEDER.get()), (int)1).pattern("IFI").pattern("PCP").pattern("IFI").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.CHEST).define(Character.valueOf('F'), (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).define(Character.valueOf('P'), (ItemLike)Items.PISTON).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)JSV1Blocks.AQUATIC_FEEDER.get()), (int)1).pattern("IDI").pattern("FCF").pattern("PDP").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.CHEST).define(Character.valueOf('F'), (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('D'), (ItemLike)Items.COBBLED_DEEPSLATE).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()))).save(recipeOutput);
    }

    private void buildAnimalRecipes(@NotNull RecipeOutput recipeOutput) {
        this.addCooking(recipeOutput, ((Item)JSV1Items.SQUID.get()).getDefaultInstance(), ((Item)JSV1Items.SQUID_COOKED.get()).getDefaultInstance(), 600);
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getItemProperties().isHasDrops() || !animal.getAnimalAttributes().getItemProperties().isHasMeat()) continue;
            Supplier<Item> meat = animal.getItems().getRawMeat();
            Supplier<Item> cooked = animal.getItems().getCookedMeat();
            this.addCooking(recipeOutput, ((Item)meat.get()).getDefaultInstance(), ((Item)cooked.get()).getDefaultInstance(), 600);
        }
    }

    private void addSmelting(RecipeOutput recipeOutput, ItemStack in, ItemStack out) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)out, (float)0.5f, (int)100).unlockedBy(JSCraftingProvider.getHasName((ItemLike)Items.FURNACE), JSCraftingProvider.has((ItemLike)Items.FURNACE)).save(recipeOutput);
    }

    private void addCooking(RecipeOutput recipeOutput, ItemStack in, ItemStack out, int time) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)out, (float)0.5f, (int)(time / 2)).unlockedBy(JSCraftingProvider.getHasName((ItemLike)in.getItem()), JSCraftingProvider.has((ItemLike)in.getItem())).unlockedBy(JSCraftingProvider.getHasName((ItemLike)out.getItem()), JSCraftingProvider.has((ItemLike)out.getItem())).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)out.getItem())) + "_smelt");
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)out, (float)0.5f, (int)(time / 2 - time / 2 / 5)).unlockedBy(JSCraftingProvider.getHasName((ItemLike)in.getItem()), JSCraftingProvider.has((ItemLike)in.getItem())).unlockedBy(JSCraftingProvider.getHasName((ItemLike)out.getItem()), JSCraftingProvider.has((ItemLike)out.getItem())).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)out.getItem())) + "_smoke");
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)out, (float)0.5f, (int)time).unlockedBy(JSCraftingProvider.getHasName((ItemLike)in.getItem()), JSCraftingProvider.has((ItemLike)in.getItem())).unlockedBy(JSCraftingProvider.getHasName((ItemLike)out.getItem()), JSCraftingProvider.has((ItemLike)out.getItem())).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)out.getItem())) + "_campfire");
    }

    private void colorGroup(@NotNull RecipeOutput recipeOutput, ColoredRegistries color, Block block) {
        this.colorBlock(recipeOutput, (Block)color.BLACK.get(), block, Items.BLACK_DYE);
        this.colorBlock(recipeOutput, (Block)color.BLUE.get(), block, Items.BLUE_DYE);
        this.colorBlock(recipeOutput, (Block)color.BROWN.get(), block, Items.BROWN_DYE);
        this.colorBlock(recipeOutput, (Block)color.CYAN.get(), block, Items.CYAN_DYE);
        this.colorBlock(recipeOutput, (Block)color.GREEN.get(), block, Items.GREEN_DYE);
        this.colorBlock(recipeOutput, (Block)color.GREY.get(), block, Items.GRAY_DYE);
        this.colorBlock(recipeOutput, (Block)color.LIGHTBLUE.get(), block, Items.LIGHT_BLUE_DYE);
        this.colorBlock(recipeOutput, (Block)color.LIGHTGREY.get(), block, Items.LIGHT_GRAY_DYE);
        this.colorBlock(recipeOutput, (Block)color.LIME.get(), block, Items.LIME_DYE);
        this.colorBlock(recipeOutput, (Block)color.MAGENTA.get(), block, Items.MAGENTA_DYE);
        this.colorBlock(recipeOutput, (Block)color.ORANGE.get(), block, Items.ORANGE_DYE);
        this.colorBlock(recipeOutput, (Block)color.PINK.get(), block, Items.PINK_DYE);
        this.colorBlock(recipeOutput, (Block)color.PURPLE.get(), block, Items.PURPLE_DYE);
        this.colorBlock(recipeOutput, (Block)color.RED.get(), block, Items.RED_DYE);
        this.colorBlock(recipeOutput, (Block)color.WHITE.get(), block, Items.WHITE_DYE);
        this.colorBlock(recipeOutput, (Block)color.YELLOW.get(), block, Items.YELLOW_DYE);
    }

    private void colorBlock(@NotNull RecipeOutput recipeOutput, Block colored, Block block, Item item) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)colored, (int)1).requires((ItemLike)block, 1).requires((ItemLike)item, 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)block), JSCraftingProvider.has((ItemLike)block)).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)colored)) + "_colored");
    }

    private void stairSlabColoredGroup(@NotNull RecipeOutput recipeOutput, ColoredRegistries coloredRoofTilesStairs, ColoredRegistries coloredRoofTilesSlab, ColoredRegistries coloredRoofTiles) {
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.BLACK.get(), (Block)coloredRoofTilesSlab.BLACK.get(), (Block)coloredRoofTiles.BLACK.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.BLUE.get(), (Block)coloredRoofTilesSlab.BLUE.get(), (Block)coloredRoofTiles.BLUE.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.BROWN.get(), (Block)coloredRoofTilesSlab.BROWN.get(), (Block)coloredRoofTiles.BROWN.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.CYAN.get(), (Block)coloredRoofTilesSlab.CYAN.get(), (Block)coloredRoofTiles.CYAN.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.GREEN.get(), (Block)coloredRoofTilesSlab.GREEN.get(), (Block)coloredRoofTiles.GREEN.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.GREY.get(), (Block)coloredRoofTilesSlab.GREY.get(), (Block)coloredRoofTiles.GREY.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.LIGHTBLUE.get(), (Block)coloredRoofTilesSlab.LIGHTBLUE.get(), (Block)coloredRoofTiles.LIGHTBLUE.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.LIGHTGREY.get(), (Block)coloredRoofTilesSlab.LIGHTGREY.get(), (Block)coloredRoofTiles.LIGHTGREY.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.LIME.get(), (Block)coloredRoofTilesSlab.LIME.get(), (Block)coloredRoofTiles.LIME.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.MAGENTA.get(), (Block)coloredRoofTilesSlab.MAGENTA.get(), (Block)coloredRoofTiles.MAGENTA.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.ORANGE.get(), (Block)coloredRoofTilesSlab.ORANGE.get(), (Block)coloredRoofTiles.ORANGE.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.PINK.get(), (Block)coloredRoofTilesSlab.PINK.get(), (Block)coloredRoofTiles.PINK.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.PURPLE.get(), (Block)coloredRoofTilesSlab.PURPLE.get(), (Block)coloredRoofTiles.PURPLE.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.RED.get(), (Block)coloredRoofTilesSlab.RED.get(), (Block)coloredRoofTiles.RED.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.WHITE.get(), (Block)coloredRoofTilesSlab.WHITE.get(), (Block)coloredRoofTiles.WHITE.get());
        this.stairSlabColored(recipeOutput, (Block)coloredRoofTilesStairs.YELLOW.get(), (Block)coloredRoofTilesSlab.YELLOW.get(), (Block)coloredRoofTiles.YELLOW.get());
    }

    private void stairSlabColored(@NotNull RecipeOutput recipeOutput, Block stair, Block slab, Block base) {
        JSCraftingProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)base), JSCraftingProvider.has((ItemLike)base)).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)stair)) + "stair");
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
    }

    private void stairSlabWallStonecutter(@NotNull RecipeOutput recipeOutput, Block stair, Block wall, Block slab, Block base) {
        JSCraftingProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)base), JSCraftingProvider.has((ItemLike)base)).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)stair)) + "stair");
        JSCraftingProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stair, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base, (int)2);
    }
}

