/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneticModule
extends JSAnimalModuleBase {
    private JSGeneData geneData;
    private boolean isFertile = true;

    public JSGeneticModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void tick() {
        if (this.shouldRefresh()) {
            this.geneData = null;
        }
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        this.getGeneData().saveToNbt(tag);
        nbt.put("js.genetics.data", (Tag)tag);
        nbt.putString("js.genetics.variant", (String)this.owner.getEntityData().get(JSEntityDataHolder.textureVariant));
        nbt.putBoolean("js.genetics.male", this.isMale());
        nbt.putBoolean("js.genetics.fertile", this.isFertile);
    }

    public JSGeneData getGeneData() {
        if (this.geneData != null) {
            return this.geneData;
        }
        CompoundTag tag = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.gene_data);
        JSGeneData data = new JSGeneData();
        data.loadFromNbt(tag);
        this.geneData = data;
        return data;
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        this.getGeneData().loadFromNbt(nbt.getCompound("js.genetics.data"));
        this.setMale(nbt.getBoolean("js.genetics.male"));
        this.setFertile(nbt.getBoolean("js.genetics.fertile"));
        this.refreshGenes();
    }

    private void refreshGenes() {
        for (JSGene jsGene : this.getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.applyTo(this.owner);
        }
    }

    public void setGeneData(JSGeneData data) {
        this.writeDataToEntity(data);
        this.refreshGenes();
    }

    public void writeDataToEntity(JSGeneData geneData) {
        CompoundTag tag = new CompoundTag();
        geneData.saveToNbt(tag);
        this.owner.getEntityData().set(JSEntityDataHolder.gene_data, (Object)tag);
        this.refresh();
        this.geneData = null;
    }

    @Override
    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setMale(level.getRandom().nextBoolean());
        JSGeneData geneData = this.getGeneData();
        geneData.setGeneSeed(level.getRandom().nextInt());
        geneData.setSizeDimorphism((float)(level.getRandom().nextInt((int)this.owner.getAnimal().getAnimalAttributes().getEntityBaseProperties().getSizeDimorphism()) + 1) / 750.0f);
        this.writeDataToEntity(geneData);
        this.refresh();
    }

    @Override
    public void init() {
    }

    public void hatch() {
        for (JSGene gene : this.getGeneData().geneDataHolder.getGENE_SET()) {
            gene.onHatch(this.owner);
        }
    }

    public void setMale(boolean male) {
        this.owner.getEntityData().set(JSEntityDataHolder.male, (Object)male);
    }

    public boolean isMale() {
        return (Boolean)this.owner.getEntityData().get(JSEntityDataHolder.male);
    }

    public boolean isFertile() {
        return this.isFertile;
    }

    public void setFertile(boolean isFertile) {
        this.isFertile = isFertile;
    }
}

