/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import travelers.server.animal.entity.task.TaskGoal;

public class JSHerdModule
extends JSAnimalModuleBase {
    private JSAnimalBase herdLeader;
    private UUID herdLeaderUUID;
    private final Set<JSAnimalBase> followers = new HashSet<JSAnimalBase>();
    private boolean isMovingToLeader;
    private int checkCooldown;
    private int lookCooldown = 40;
    private int maxDistance;
    private int trueLeaderCooldown = 0;
    private JSAnimalBase cachedTrueLeader;

    public JSHerdModule(JSAnimalBase owner) {
        super(owner);
    }

    public void setHerdLeader(JSAnimalBase leader) {
        this.herdLeader = leader;
        this.herdLeaderUUID = leader != null ? leader.getUUID() : null;
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        if (this.herdLeaderUUID != null) {
            nbt.putString("js.herd.herdleader", this.herdLeaderUUID.toString());
        }
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        String s = nbt.getString("js.herd.herdleader");
        if (!s.isEmpty()) {
            this.herdLeaderUUID = UUID.fromString(s);
        }
    }

    @Override
    public void init() {
        this.maxDistance = (int)this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxDistanceToPackLeader();
        this.checkCooldown = 0;
        this.lookCooldown = 40;
    }

    @Override
    public void serverAiStep() {
        this.resolveLeaderByUUID();
        this.ensureTwoWayLink();
        this.cleanupFollowers();
        if (this.isFollower()) {
            this.tickFollower();
        } else {
            this.tickLeader();
        }
    }

    private void tickFollower() {
        if (!this.isEntityValid(this.herdLeader)) {
            this.stopFollowing();
            return;
        }
        if (this.owner.getNavigationController().isDone() && this.isMovingToLeader) {
            this.isMovingToLeader = false;
        }
        double minDist = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMinDistanceToPackLeader();
        if (!this.isMovingToLeader && this.owner.distanceToSqr((Entity)this.herdLeader) > minDist) {
            if (this.checkCooldown > 0) {
                --this.checkCooldown;
            } else {
                this.tryMoveToLeader();
            }
        }
        this.owner.restrictTo(this.herdLeader.getOnPos(), this.maxDistance);
    }

    private void tryMoveToLeader() {
        JSAvianBase av;
        if (this.owner.isDead()) {
            return;
        }
        JSAnimalBase jSAnimalBase = this.owner;
        if (jSAnimalBase instanceof JSAvianBase && (av = (JSAvianBase)jSAnimalBase).isDiving()) {
            return;
        }
        if (this.owner.getTarget() != null) {
            return;
        }
        if (this.owner.getFleeTarget() != null) {
            return;
        }
        if (this.owner.getModules().getMetabolismModule().isHungry() || this.owner.getModules().getMetabolismModule().isThirsty()) {
            return;
        }
        this.isMovingToLeader = true;
        this.owner.getTaskController().stopTask(TaskGoal.MOVEMENT);
        CompletableFuture moveTask = this.owner.getNavigationController().moveTo((Entity)this.herdLeader);
        if (moveTask != null) {
            moveTask.thenAccept(path -> {
                if (path == null) {
                    this.isMovingToLeader = false;
                    this.checkCooldown = 15;
                }
            });
        }
    }

    private void tickLeader() {
        this.mergeNearbyHerds();
    }

    private void mergeNearbyHerds() {
        if (this.lookCooldown > 0) {
            --this.lookCooldown;
            return;
        }
        AABB box = this.owner.getBoundingBox().inflate(64.0);
        List candidates = this.owner.level().getEntitiesOfClass(JSAnimalBase.class, box, this::canHerdWith);
        if (candidates.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        Set leaders = candidates.stream().map(e -> e.getModules().getHerdModule().getTrueLeader()).filter(this::isEntityValid).collect(Collectors.toSet());
        if (this.isLeader()) {
            leaders.add(this.owner);
        }
        if (leaders.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        JSAnimalBase bestLeader = leaders.stream().max(Comparator.comparingInt(l -> l.getModules().getHerdModule().getHerdSize()).thenComparing(Entity::getUUID)).orElse(this.owner);
        JSHerdModule bestMod = bestLeader.getModules().getHerdModule();
        int maxSize = bestLeader.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize();
        for (JSAnimalBase l2 : new HashSet(leaders)) {
            if (l2 == bestLeader) continue;
            JSHerdModule lm = l2.getModules().getHerdModule();
            for (JSAnimalBase f : new HashSet<JSAnimalBase>(lm.followers)) {
                if (bestMod.getHerdSize() >= maxSize) break;
                f.getModules().getHerdModule().startFollowing(bestLeader);
            }
            if (bestMod.getHerdSize() >= maxSize) continue;
            l2.getModules().getHerdModule().startFollowing(bestLeader);
        }
        this.lookCooldown = 40;
    }

    public void addFollowers(Stream<? extends JSAnimalBase> newFollowers) {
        newFollowers.filter(f -> f != this.owner && !f.isDead()).forEach(f -> {
            JSHerdModule hm = f.getModules().getHerdModule();
            if (!hm.isFollower()) {
                hm.startFollowing(this.owner);
            }
        });
    }

    public void startFollowing(JSAnimalBase leader) {
        if (leader == this.owner) {
            return;
        }
        JSHerdModule lm = leader.getModules().getHerdModule();
        if (!lm.canBeFollowed()) {
            return;
        }
        this.stopFollowing();
        this.setHerdLeader(leader);
        lm.addFollower(this.owner);
    }

    public void stopFollowing() {
        if (this.herdLeader != null) {
            this.herdLeader.getModules().getHerdModule().removeFollower(this.owner);
        }
        this.herdLeader = null;
        this.herdLeaderUUID = null;
        this.owner.clearRestriction();
        this.isMovingToLeader = false;
    }

    public void addFollower(JSAnimalBase animal) {
        if (animal != null && animal != this.owner) {
            this.followers.add(animal);
        }
    }

    public void removeFollower(JSAnimalBase animal) {
        this.followers.remove((Object)animal);
    }

    public int getHerdSize() {
        return this.isLeader() ? 1 + this.followers.size() : 1;
    }

    public boolean canBeFollowed() {
        int maxSize = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize();
        return this.followers.size() < maxSize;
    }

    public boolean isFollower() {
        return this.herdLeader != null || this.herdLeaderUUID != null;
    }

    public boolean isLeader() {
        return !this.isFollower();
    }

    public JSAnimalBase getTrueLeader() {
        Level level;
        if (this.trueLeaderCooldown > 0) {
            --this.trueLeaderCooldown;
            return this.cachedTrueLeader;
        }
        JSHerdModule cur = this;
        HashSet<UUID> visited = new HashSet<UUID>();
        while (cur.herdLeader == null && cur.herdLeaderUUID != null && (level = cur.owner.level()) instanceof ServerLevel) {
            JSAnimalBase b;
            ServerLevel sl = (ServerLevel)level;
            Entity e = sl.getEntity(cur.herdLeaderUUID);
            JSAnimalBase jSAnimalBase = cur.herdLeader = e instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e) ? b : null;
            if (cur.herdLeader != null) continue;
            break;
        }
        while (cur.herdLeader != null && cur.herdLeader != cur.owner) {
            UUID id = cur.herdLeader.getUUID();
            if (!visited.add(id)) {
                this.cachedTrueLeader = null;
                this.trueLeaderCooldown = 200;
                return null;
            }
            cur = cur.herdLeader.getModules().getHerdModule();
            if (cur.isFollower()) continue;
            break;
        }
        if (!this.isEntityValid(cur.owner)) {
            this.cachedTrueLeader = null;
            this.trueLeaderCooldown = 200;
            return null;
        }
        this.cachedTrueLeader = cur.owner;
        this.trueLeaderCooldown = 20;
        return this.cachedTrueLeader;
    }

    public double getHerdStrength() {
        if (this.owner == null || this.owner.isDead()) {
            return 0.0;
        }
        double sum = JSHerdModule.getEntityStrength(this.owner);
        for (JSAnimalBase f : this.followers) {
            if (f == null || f.isDead()) continue;
            sum += JSHerdModule.getEntityStrength(f);
        }
        return sum;
    }

    private static double getEntityStrength(JSAnimalBase e) {
        return e.getBbWidth() * e.getBbWidth() * e.getBbHeight();
    }

    private void resolveLeaderByUUID() {
        JSAnimalBase b;
        ServerLevel sl;
        Entity e;
        Level level;
        if (this.herdLeader == null && this.herdLeaderUUID != null && (level = this.owner.level()) instanceof ServerLevel && (e = (sl = (ServerLevel)level).getEntity(this.herdLeaderUUID)) instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e)) {
            this.herdLeader = b;
        }
    }

    private void ensureTwoWayLink() {
        if (this.herdLeader != null) {
            JSHerdModule lm = this.herdLeader.getModules().getHerdModule();
            if (!lm.followers.contains((Object)this.owner)) {
                lm.followers.add(this.owner);
            }
        }
    }

    private boolean isEntityValid(JSAnimalBase a) {
        return a != null && !a.isDead() && !a.isRemoved();
    }

    private void cleanupFollowers() {
        if (this.followers.isEmpty()) {
            return;
        }
        UUID myId = this.owner.getUUID();
        this.followers.removeIf(f -> {
            if (f == null || f.isDead() || f.isRemoved()) {
                return true;
            }
            JSHerdModule hm = f.getModules().getHerdModule();
            boolean pointsToUs = hm.herdLeader == this.owner || myId.equals(hm.herdLeaderUUID);
            return !pointsToUs;
        });
    }

    private boolean canHerdWith(JSAnimalBase other) {
        if (other == this.owner) {
            return false;
        }
        JSSocialGroupProperties props = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties();
        for (Class<LivingEntity> type : props.getHerdCompatible()) {
            if (!type.isInstance((Object)other)) continue;
            return true;
        }
        return false;
    }

    public JSAnimalBase getHerdLeader() {
        return this.herdLeader;
    }

    public UUID getHerdLeaderUUID() {
        return this.herdLeaderUUID;
    }

    public Set<JSAnimalBase> getFollowers() {
        return this.followers;
    }

    public boolean isMovingToLeader() {
        return this.isMovingToLeader;
    }

    public int getCheckCooldown() {
        return this.checkCooldown;
    }

    public int getLookCooldown() {
        return this.lookCooldown;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getTrueLeaderCooldown() {
        return this.trueLeaderCooldown;
    }

    public JSAnimalBase getCachedTrueLeader() {
        return this.cachedTrueLeader;
    }
}

