/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindFoodTask
extends JSTaskBase {
    protected volatile Entity targetEntity;
    private volatile boolean shouldMoveToLastKnown;
    protected boolean setTargetTypes = true;
    protected boolean targetMeatCubes;
    protected boolean targetHayCubes;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPathChecks = new AtomicInteger();
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 16;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int CACHE_EXPIRY = 40;
    private static final int SLICE_SIZE = 32;
    private final List<Entity> candidateCache = Collections.synchronizedList(new ArrayList(32));
    private int cacheTick = -9999;
    private int ticks;

    public JSFindFoodTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double hunger = this.animal.getModules().getMetabolismModule().hungerPercentage();
        if (hunger > 0.8) {
            return TaskPriority.LOW;
        }
        if (hunger > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (hunger > 0.4) {
            return TaskPriority.HIGH;
        }
        if (hunger > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isHungerEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        if (this.setTargetTypes) {
            Diet diet = this.animal.getModules().getMetabolismModule().getDiet();
            this.targetMeatCubes = diet.isCanEatMeatCube();
            this.targetHayCubes = diet.isCanEatHaybale();
            this.setTargetTypes = false;
        }
        if (this.targetEntity != null && !this.targetEntity.isAlive()) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null && this.ticks - this.cacheTick >= 20) {
            this.findTargets(128.0f, null);
            this.cacheTick = this.ticks;
        }
        ++this.ticks;
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public boolean canInterrupt() {
        return this.targetEntity == null;
    }

    public void onStart() {
        CompletableFuture future;
        if (!this.shouldMoveToLastKnown && this.targetEntity != null && !this.animal.getNavigationController().isLookingForPath() && (future = this.animal.getNavigationController().createPath(this.targetEntity.blockPosition(), 0.0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath);
                    this.animal.setAggressive(true);
                } else {
                    this.targetEntity = null;
                }
            });
        }
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public void tick() {
        CompletableFuture future;
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        if (this.shouldMoveToLastKnown) {
            this.shouldMoveToLastKnown = false;
        }
        if (this.isCloseToTarget()) {
            this.eatTarget();
            return;
        }
        if (this.targetEntity != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0 && this.pendingPathChecks.get() < 4 && (future = this.animal.getNavigationController().createPath(this.targetEntity.blockPosition(), 0.0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath);
                } else {
                    this.targetEntity = null;
                }
            });
            this.checkCooldown = 40;
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.shouldMoveToLastKnown = false;
        this.pendingPathChecks.set(0);
        this.candidateCache.clear();
    }

    public void onStop() {
        this.targetEntity = null;
        this.animal.setAggressive(false);
    }

    /*
     * Unable to fully structure code
     */
    private void eatTarget() {
        block6: {
            block8: {
                block7: {
                    this.animal.getNavigationController().stop();
                    if (this.animal.curEatTicks == 0) {
                        this.animal.curEatTicks = 20;
                    }
                    if (this.targetEntity != null) {
                        this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, this.targetEntity.position());
                    }
                    if (this.animal.curEatTicks > 5) break block6;
                    var4_1 = this.targetEntity;
                    if (!(var4_1 instanceof IJSEdibleEntity)) break block7;
                    edible = (IJSEdibleEntity)var4_1;
                    this.animal.getModules().getMetabolismModule().setHunger(this.animal.getModules().getMetabolismModule().getMaxHunger());
                    break block8;
                }
                var4_1 = this.targetEntity;
                if (!(var4_1 instanceof JSAnimalBase)) ** GOTO lbl-1000
                corpse = (JSAnimalBase)var4_1;
                if (this.animal.getModules().getMetabolismModule().canEatCorpse(corpse)) {
                    this.animal.getModules().getMetabolismModule().eatCorpse(corpse);
                } else if ((var4_1 = this.targetEntity) instanceof ItemEntity) {
                    item = (ItemEntity)var4_1;
                    if (this.animal.getModules().getMetabolismModule().eatItem(item.getItem())) {
                        item.discard();
                    }
                }
            }
            this.targetEntity = null;
        }
    }

    public boolean isCloseToTarget() {
        return this.targetEntity != null && JSTaskUtils.isCloseEnough(this.animal, this.targetEntity.blockPosition().getCenter(), 2.0f);
    }

    public void findTargets(float range, Vec3 pos) {
        if (range <= 1.0f) {
            range = 2.0f;
        }
        Level level = this.animal.level();
        if (this.ticks - this.cacheTick < 40 && !this.candidateCache.isEmpty()) {
            if (this.rng.nextDouble() < 0.15) {
                Collections.shuffle(this.candidateCache, this.rng);
            }
            return;
        }
        this.candidateCache.clear();
        this.cacheTick = this.ticks;
        AABB searchBox = this.animal.getBoundingBox().inflate((double)range, (double)range * 4.0, (double)range);
        if (pos != null) {
            searchBox = searchBox.move(pos);
        }
        ArrayList<Entity> found = new ArrayList<Entity>();
        if (this.targetMeatCubes) {
            found.addAll(level.getEntitiesOfClass(JSAnimalBase.class, searchBox, e -> e.isDead() && !this.animal.is((Entity)e)));
            found.addAll(level.getEntitiesOfClass(MeatEntity.class, searchBox, Entity::isAlive));
        }
        if (this.targetHayCubes) {
            found.addAll(level.getEntitiesOfClass(HaybaleEntity.class, searchBox, Entity::isAlive));
        }
        found.addAll(level.getEntitiesOfClass(ItemEntity.class, searchBox, e -> this.animal.getModules().getMetabolismModule().getDiet().canEatItem(e.getItem())));
        if (found.isEmpty()) {
            return;
        }
        found.removeIf(e -> e == null || !e.isAlive() || !this.cheapCanSee(level, (Entity)e));
        if (found.isEmpty()) {
            return;
        }
        found.sort((a, b) -> {
            double d1 = this.animal.position().distanceToSqr(a.position()) * (1.0 + this.rng.nextDouble() * 0.25);
            double d2 = this.animal.position().distanceToSqr(b.position()) * (1.0 + this.rng.nextDouble() * 0.25);
            return Double.compare(d1, d2);
        });
        if (found.size() > 16) {
            found = new ArrayList(found.subList(0, 16));
        }
        this.candidateCache.addAll(found);
        int pathReqs = 0;
        for (Entity targ : found) {
            CompletableFuture future;
            if (this.targetEntity != null || pathReqs >= 3 || this.pendingPathChecks.get() >= 4) break;
            double distSqr = this.animal.position().distanceToSqr(targ.position());
            if (distSqr > (double)(range * range) * 1.5 || (future = this.animal.getNavigationController().createPath(targ.blockPosition(), 0.0)) == null) continue;
            this.pendingPathChecks.incrementAndGet();
            ++pathReqs;
            Entity finalTarg = targ;
            future.thenAccept(jsPath -> {
                try {
                    if (jsPath != null && finalTarg.isAlive() && this.cheapCanSee(level, finalTarg)) {
                        if (this.targetEntity == null) {
                            this.targetEntity = finalTarg;
                        } else {
                            double cur = this.animal.position().distanceToSqr(this.targetEntity.position());
                            double newd = this.animal.position().distanceToSqr(finalTarg.position());
                            if (newd + 1.0E-6 < cur && this.rng.nextDouble() < 0.65) {
                                this.targetEntity = finalTarg;
                            }
                        }
                    }
                }
                finally {
                    this.pendingPathChecks.decrementAndGet();
                }
            });
        }
        if (pathReqs == 0 && this.targetEntity == null) {
            this.shouldMoveToLastKnown = true;
        }
    }

    private boolean cheapCanSee(Level level, Entity e) {
        Vec3 to;
        if (e == null) {
            return false;
        }
        Vec3 from = this.animal.getEyePosition();
        BlockHitResult res = level.clip(new ClipContext(from, to = e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.animal));
        return res.getType() != HitResult.Type.BLOCK;
    }
}

