/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSAirAndWaterRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround) {
        boolean flag = JSGoalUtils.mobRestricted(mob, maxDistance);
        return JSRandomPos.generateBestRandomPos(() -> JSAirAndWaterRandomPos.generateRandomPos(mob, maxDistance, yRange, maxDistanceOfGround, flag), arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos generateRandomPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround, boolean shortCircuit) {
        BlockPos pos;
        RandomSource rng = mob.getRandom();
        int baseX = mob.blockPosition().getX();
        int baseY = mob.blockPosition().getY();
        int baseZ = mob.blockPosition().getZ();
        int xRange = Math.max(1, maxDistance * 2 + 1);
        int ySafeRange = Math.max(1, yRange * 2 + 1);
        int x = baseX + rng.nextInt(xRange) - maxDistance;
        int z = baseZ + rng.nextInt(xRange) - maxDistance;
        int y = baseY + rng.nextInt(ySafeRange) - yRange;
        if (y < baseY + 2) {
            y = baseY + 2 + rng.nextInt(Math.max(1, yRange));
        }
        if (maxDistanceOfGround != -1) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(x, baseY, z);
            while (cursor.getY() > mob.level().getMinBuildHeight() && mob.level().isEmptyBlock((BlockPos)cursor)) {
                cursor.move(Direction.DOWN);
            }
            int groundY = cursor.getY();
            int minY = groundY + 1;
            int maxY = groundY + maxDistanceOfGround;
            y = Math.max(minY, Math.min(maxY, y));
        }
        if (JSGoalUtils.isOutsideLimits(pos = new BlockPos(x, y, z), mob) || JSGoalUtils.isRestricted(shortCircuit, mob, pos)) {
            return null;
        }
        return JSGoalUtils.hasMalus(mob, pos) ? null : pos;
    }
}

