/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSHoverRandomPos {
    private static final Random rng = new Random();

    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int yRange, double x, double z, float angleVarianceRadians, int maxSwimUp, int minSwimUp) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos direction = JSRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, x, z, angleVarianceRadians);
            if (direction == null) {
                return null;
            }
            BlockPos toward = JSHoverRandomPos.generateValidTarget(mob, radius, restricted, direction);
            if (toward == null) {
                return null;
            }
            int swimUpAmount = rng.nextInt(maxSwimUp - minSwimUp + 1) + minSwimUp;
            BlockPos elevated = JSRandomPos.moveUpToAboveSolid(toward, swimUpAmount, mob.level().getMaxBuildHeight(), pos -> JSGoalUtils.isSolid(mob, pos));
            return JSHoverRandomPos.isValidFinalHoverTarget(mob, elevated) ? elevated : null;
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos generateValidTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = JSRandomPos.generateRandomPosTowardDirection((PathfinderMob)mob, radius, offset);
        return candidate != null && !JSGoalUtils.isOutsideLimits(candidate, mob) && !JSGoalUtils.isRestricted(restricted, mob, candidate) && !JSGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }

    private static boolean isValidFinalHoverTarget(SmartAnimalBase mob, BlockPos pos) {
        return !JSGoalUtils.isWater(mob, pos) && !JSGoalUtils.hasMalus(mob, pos);
    }
}

