/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JSRandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;
    private static final Random rng = new Random();

    public static BlockPos generateRandomDirection(int horizontalDistance, int verticalDistance) {
        int dx = rng.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        int dy = rng.nextInt(2 * verticalDistance + 1) - verticalDistance;
        int dz = rng.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        return new BlockPos(dx, dy, dz);
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(int maxHorizontalDifference, int yRange, int baseY, double baseX, double baseZ, double maxAngleDelta) {
        double baseAngle = Mth.atan2((double)baseZ, (double)baseX) - 1.5707963267948966;
        double angle = baseAngle + (2.0 * (double)rng.nextFloat() - 1.0) * maxAngleDelta;
        double distance = Math.sqrt(rng.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)maxHorizontalDifference;
        double offsetX = -distance * Math.sin(angle);
        double offsetZ = distance * Math.cos(angle);
        if (Math.abs(offsetX) > (double)maxHorizontalDifference || Math.abs(offsetZ) > (double)maxHorizontalDifference) {
            return null;
        }
        int y = baseY + rng.nextInt(2 * yRange + 1) - yRange;
        return BlockPos.containing((double)offsetX, (double)y, (double)offsetZ);
    }

    public static BlockPos moveUpOutOfSolid(BlockPos pos, int maxY, Predicate<BlockPos> isSolid) {
        if (!isSolid.test(pos)) {
            return pos;
        }
        BlockPos current = pos.above();
        while (current.getY() < maxY && isSolid.test(current)) {
            current = current.above();
        }
        return current;
    }

    public static BlockPos moveUpToAboveSolid(BlockPos pos, int aboveSolidAmount, int maxY, Predicate<BlockPos> isSolid) {
        BlockPos next;
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount must be >= 0, got: " + aboveSolidAmount);
        }
        if (!isSolid.test(pos)) {
            return pos;
        }
        BlockPos base = pos.above();
        while (base.getY() < maxY && isSolid.test(base)) {
            base = base.above();
        }
        BlockPos check = base;
        for (int i = 0; i < aboveSolidAmount && check.getY() < maxY && !isSolid.test(next = check.above()); ++i) {
            check = next;
        }
        return check;
    }

    @Nullable
    public static Vec3 generateBestRandomPos(Supplier<BlockPos> supplier, ToDoubleFunction<BlockPos> scorer) {
        double bestScore = Double.NEGATIVE_INFINITY;
        BlockPos bestPos = null;
        for (int i = 0; i < 10; ++i) {
            double score;
            BlockPos pos = supplier.get();
            if (pos == null || !((score = scorer.applyAsDouble(pos)) > bestScore)) continue;
            bestScore = score;
            bestPos = pos;
        }
        return bestPos != null ? Vec3.atBottomCenterOf(bestPos) : null;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob mob, int range, BlockPos offset) {
        int dx = offset.getX();
        int dz = offset.getZ();
        if (mob.hasRestriction() && range > 1) {
            BlockPos center = mob.getRestrictCenter();
            dx += mob.getX() > (double)center.getX() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
            dz += mob.getZ() > (double)center.getZ() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
        }
        return BlockPos.containing((double)(mob.getX() + (double)dx), (double)(mob.getY() + (double)offset.getY()), (double)(mob.getZ() + (double)dz));
    }

    @Nullable
    public static Vec3 findTargetPos(PathfinderMob mob, int xRange, int yRange, int yVariation) {
        BlockPos origin = mob.blockPosition();
        return JSRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = JSRandomPos.generateRandomDirection(xRange, yVariation);
            return origin.offset((Vec3i)offset);
        }, pos -> mob.getWalkTargetValue(pos));
    }
}

