/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj;

import com.google.common.base.Supplier;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersMoveAnalysis;

public class JSAnimal<T extends JSAnimalBase>
extends TravelersAnimal<T> {
    private JSAnimator<T> animator;

    public JSAnimal(JSTravelersAttributes<T> animalAttributes) {
        super(animalAttributes);
        this.init(animalAttributes);
        this.setItemInterface(new JSTravelersItems());
        if (this.getAnimalAttributes().getItemProperties().isHasDrops()) {
            this.getItems().init(animalAttributes, this);
        }
        if (animalAttributes.getMiscProperties().isExtinct()) {
            JSAnimals.setEraEnabled(animalAttributes.getMiscProperties().getEra(), this);
        }
    }

    public void animate(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (this.animator != null) {
            this.animator.animate((JSAnimalBase)base, moveAnalysis, animationManager);
        }
    }

    public void animateServer(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (this.animator != null) {
            this.animator.animateServer((JSAnimalBase)base, moveAnalysis, animationManager);
        }
    }

    protected void init(JSTravelersAttributes<T> animalAttributes) {
    }

    public void setEntityType(Supplier<EntityType<? extends Entity>> entityType) {
        super.setEntityType(entityType);
        this.getItems().initSpawnEgg(this.getAnimalAttributes(), this);
    }

    public JSTravelersItems<T> getItems() {
        return (JSTravelersItems)super.getItems();
    }

    public JSTravelersAttributes<T> getAnimalAttributes() {
        return (JSTravelersAttributes)super.getAnimalAttributes();
    }

    public void setAnimator(JSAnimator<T> animator) {
        this.animator = animator;
    }
}

