/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSAnimalBaseLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    private final boolean hasGenders;

    public JSAnimalBaseLocator() {
        this(true);
    }

    public JSAnimalBaseLocator(boolean gendered) {
        this.hasGenders = gendered;
    }

    public ResourceLocation getTextureLocation(T entity) {
        String entity_name = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
        String growthStage = ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
        if (((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
            JSVariants.JSVariant variant = JSVariants.fromLocation((String)entity.getEntityData().get(JSEntityDataHolder.textureVariant));
            if (variant == JSVariants.NONE || !((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct()) {
                if (!this.hasGenders) {
                    return JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + ".png");
                }
                ResourceLocation maleTextureLocation = JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + "_male.png");
                ResourceLocation femaleTextureLocation = JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + "_female.png");
                return ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() ? maleTextureLocation : femaleTextureLocation;
            }
            ResourceLocation location = variant.location();
            if (variant.ignoresGenders()) {
                return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/geo/animal/" + entity_name + "/variants/" + entity_name + "_adult_" + location.getPath() + ".png"));
            }
            if (((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isGenderedVariants()) {
                ResourceLocation maleTextureLocation = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/geo/animal/" + entity_name + "/variants/" + entity_name + "_adult_" + location.getPath() + "_male.png"));
                ResourceLocation femaleTextureLocation = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/geo/animal/" + entity_name + "/variants/" + entity_name + "_adult_" + location.getPath() + "_female.png"));
                return ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() ? maleTextureLocation : femaleTextureLocation;
            }
            return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/geo/animal/" + entity_name + "/variants/" + entity_name + "_adult_" + location.getPath() + ".png"));
        }
        return JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + ".png");
    }

    public ResourceLocation getLuxLocation(T entity) {
        String entity_name = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
        String growthStage = ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
        return JSCommon.createId("textures/geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + "_lux.png");
    }

    public ResourceLocation getModelLocation(T entity) {
        String entity_name = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
        String growthStage = ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
        return JSCommon.createId("geo/animal/" + entity_name + "/" + entity_name + "_" + growthStage + ".geo.json");
    }

    public ResourceLocation getDefaultModelLocation(T entity) {
        String entity_name = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
        return JSCommon.createId("geo/animal/" + entity_name + "/" + entity_name + "_adult.geo.json");
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String entity_name = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
        boolean needsBabyAnimations = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isBabyAnimations() && ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
        return JSCommon.createId("animations/animal/" + entity_name + "/" + entity_name + (needsBabyAnimations ? "_baby.animation.json" : ".animation.json"));
    }
}

