/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block;

import com.google.common.base.Supplier;
import jp.jurassicsaga.server.base.block.obj.furniture.BenchBlock;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import travelers.util.helper.TravelersRegistry;

public class JSBlocks {
    public static final TravelersRegistry<Block> BLOCKS = new TravelersRegistry((Registry)BuiltInRegistries.BLOCK, "jurassicsaga").storeValues();
    public static final Supplier<Block> BENCH_OAK_LOG = JSBlocks.registerBlockWItem("bench_oak", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_SPRUCE_LOG = JSBlocks.registerBlockWItem("bench_spruce", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_BIRCH_LOG = JSBlocks.registerBlockWItem("bench_birch", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_JUNGLE_LOG = JSBlocks.registerBlockWItem("bench_jungle", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_ACACIA_LOG = JSBlocks.registerBlockWItem("bench_acacia", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_DARK_OAK_LOG = JSBlocks.registerBlockWItem("bench_dark_oak", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_MANGROVE_LOG = JSBlocks.registerBlockWItem("bench_mangrove", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_CHERRY_LOG = JSBlocks.registerBlockWItem("bench_cherry", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_CRIMSON_STEM = JSBlocks.registerBlockWItem("bench_crimson", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());
    public static final Supplier<Block> BENCH_WARPED_STEM = JSBlocks.registerBlockWItem("bench_warped", (Supplier<Block>)((Supplier)BenchBlock::new), new Item.Properties());

    public static void init() {
        JSV1Blocks.init();
    }

    public static Supplier<Block> registerBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    public static Supplier<Block> registerBlockWItem(String name, Supplier<Block> block, Item.Properties properties) {
        Supplier blockRegistryObject = BLOCKS.register(name, block);
        JSItems.registerItem(name, (Supplier<Item>)((Supplier)() -> new BlockItem((Block)blockRegistryObject.get(), properties)));
        return blockRegistryObject;
    }

    static {
        for (Era value : Era.values()) {
            if (value.isHasFossilOre()) {
                value.setFossilOre(JSBlocks.registerBlockWItem(value.getEraName() + "_fluvial_fossil_ore", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE))), new Item.Properties()));
            }
            if (!value.isHasMarineOre()) continue;
            value.setMarineOre(JSBlocks.registerBlockWItem(value.getEraName() + "_marine_fossil_ore", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE))), new Item.Properties()));
        }
    }
}

